/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.tile;

import com.valkyrieofnight.simplegenerators.network.PacketDispatcher;
import com.valkyrieofnight.simplegenerators.network.packet.PacketGeneratorBaseUpdate;
import com.valkyrieofnight.valkyrielib.energy.EnergyProvider;
import com.valkyrieofnight.valkyrielib.energy.EnergyUtil;
import com.valkyrieofnight.valkyrielib.energy.IEnergyProvider;
import com.valkyrieofnight.valkyrielib.gui.IGuiHandlingObject;
import com.valkyrieofnight.valkyrielib.network.VLPacket;
import com.valkyrieofnight.valkyrielib.tileentity.VLTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileGeneratorBase
extends VLTileEntity
implements ITickable,
IGuiHandlingObject {
    public EnergyProvider eBuffer;
    private boolean hasStartedProcessing = false;
    protected int currentDuration = 0;
    protected int currentProgress = 0;
    protected int currentRFT = 0;
    protected int ticker = 0;
    protected boolean updateClients = false;
    protected boolean processing = false;

    public TileGeneratorBase(int eBufferSize) {
        this.eBuffer = new EnergyProvider(eBufferSize);
    }

    protected void setBufferSize(int eBUfferSize) {
        int amount = this.eBuffer.getEnergyStored();
        this.eBuffer = new EnergyProvider(eBUfferSize);
        this.eBuffer.setEnergyStored(amount);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasStartedProcessing && this.canProcess()) {
                if (this.currentProgress < this.currentDuration) {
                    this.onProcessTick();
                    this.updateClient();
                    this.updateClients = true;
                    ++this.currentProgress;
                }
                if (this.currentDuration <= this.currentProgress) {
                    this.onProcessComplete();
                    this.hasStartedProcessing = false;
                    this.currentDuration = this.getCurrentProcessDuration();
                    this.currentProgress = 0;
                }
            }
            if (!this.hasStartedProcessing) {
                this.currentRFT = this.getRFPT();
                this.currentDuration = this.getDuration();
                if (this.onStartProcess()) {
                    this.hasStartedProcessing = true;
                }
            }
            this.handleEnergy();
        }
    }

    public void updateClient() {
        VLPacket pack = this.getPacket();
        if (pack != null) {
            PacketDispatcher.DISPATCHER.sendToAllAround((IMessage)pack, this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 4.0);
        }
    }

    public boolean func_145842_c(int id, int type) {
        System.out.println("test");
        switch (id) {
            case 1: {
                this.eBuffer.setEnergyStored(type);
            }
            case 2: {
                System.out.println("dfsghfsdl");
            }
        }
        return super.func_145842_c(id, type);
    }

    public VLPacket getPacket() {
        return new PacketGeneratorBaseUpdate(this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.eBuffer.writeToNBT(nbt);
        nbt.func_74757_a("started", this.hasStartedProcessing);
        nbt.func_74768_a("cur_dur", this.currentDuration);
        nbt.func_74768_a("cur_pro", this.currentProgress);
        nbt.func_74768_a("cur_rft", this.currentRFT);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.eBuffer.readFromNBT(nbt);
        this.hasStartedProcessing = nbt.func_74767_n("started");
        this.currentDuration = nbt.func_74762_e("cur_dur");
        this.currentProgress = nbt.func_74762_e("cur_pro");
        this.currentRFT = nbt.func_74762_e("cur_rft");
    }

    public void handleEnergy() {
        EnergyUtil.sendEnergyToFirst((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IEnergyProvider)this.eBuffer, (EnumFacing[])this.validConectionDirections());
    }

    public IEnergyProvider getEnergyProvider() {
        return this.eBuffer;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.eBuffer;
        }
        return (T)super.getCapability(capability, facing);
    }

    public String calculateTimeLeft() {
        String hour;
        int ticks = Math.abs(this.currentDuration - this.currentProgress);
        int totalSecs = ticks / 20;
        int tdays = totalSecs / 86400;
        int hours = totalSecs / 3600;
        int minutes = totalSecs % 3600 / 60;
        int seconds = totalSecs % 60;
        String secs = seconds < 10 ? "0" + seconds : seconds + "";
        String mins = minutes < 10 ? "0" + minutes : minutes + "";
        String string = hour = hours < 10 ? "0" + hours : hours + "";
        String days = tdays < 100 ? "0" + tdays : (tdays < 10 ? "00" + tdays : tdays + "");
        return (tdays > 0 ? days + ":" : "") + (hours > 0 ? hour + ":" : "") + (minutes > 0 ? mins + ":" : "") + secs;
    }

    @SideOnly(value=Side.CLIENT)
    public void clientUpdate(int currDur, int currProg, int currRFT, int eLevel) {
        this.currentDuration = currDur;
        this.currentProgress = currProg;
        this.currentRFT = currRFT;
        this.eBuffer.setEnergyStored(eLevel);
    }

    public abstract int getDuration();

    public abstract boolean onStartProcess();

    public abstract boolean canProcess();

    public abstract void onProcessTick();

    public abstract int getRFPT();

    public int getCurrentRFT() {
        return this.currentRFT;
    }

    public abstract void onProcessComplete();

    public int getCurrentProcessDuration() {
        return this.getDuration();
    }

    public int getCurrentDuration() {
        return this.currentDuration;
    }

    public int getProgress() {
        return this.currentProgress;
    }

    public abstract EnumFacing[] validConectionDirections();

    public float getEnergyLevelScale() {
        return (float)this.eBuffer.getEnergyStored() / (float)this.eBuffer.getMaxEnergyStored();
    }
}

