/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import cofh.api.energy.IEnergyContainerItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mcjty.lib.compat.CompatItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.BlackListSettings;
import romelo333.notenoughwands.KeyBindings;
import romelo333.notenoughwands.ModItems;
import romelo333.notenoughwands.NotEnoughWands;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.varia.ItemCapabilityProvider;
import romelo333.notenoughwands.varia.Tools;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI")})
public class GenericWand
extends CompatItem
implements IEnergyContainerItem {
    protected int needsxp = 0;
    protected int needsrf = 0;
    protected int maxrf = 0;
    protected int availability = AVAILABILITY_NORMAL;
    protected int lootRarity = 10;
    public static int AVAILABILITY_NOT = 0;
    public static int AVAILABILITY_CREATIVE = 1;
    public static int AVAILABILITY_ADVANCED = 2;
    public static int AVAILABILITY_NORMAL = 3;
    private static List<GenericWand> wands = new ArrayList<GenericWand>();

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)this, 0, new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityProvider(stack, this);
    }

    public static double checkPickup(EntityPlayer player, World world, BlockPos pos, Block block, float maxHardness) {
        IBlockState state = world.func_180495_p(pos);
        float hardness = block.func_176195_g(state, world, pos);
        if (hardness < 0.0f || hardness > maxHardness) {
            Tools.error(player, "This block is to hard to take!");
            return -1.0;
        }
        if (!block.canEntityDestroy(state, (IBlockAccess)world, pos, (Entity)player)) {
            Tools.error(player, "You are not allowed to take this block!");
            return -1.0;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot take it!");
            return -1.0;
        }
        double cost = BlackListSettings.getBlacklistCost(block);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to take this block");
            return -1.0;
        }
        return cost;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        if (this.needsrf > 0) {
            list.add(TextFormatting.GREEN + "Energy: " + this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (this.needsrf > 0 && Config.showDurabilityBarForRF) {
            return true;
        }
        return super.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (this.needsrf > 0 && Config.showDurabilityBarForRF) {
            int max = this.getMaxEnergyStored(stack);
            return (double)(max - this.getEnergyStored(stack)) / (double)max;
        }
        return super.getDurabilityForDisplay(stack);
    }

    protected GenericWand setup(String name) {
        if (this.availability > 0) {
            this.func_77625_d(1);
            this.setNoRepair();
            this.func_77655_b("notenoughwands." + name);
            this.setRegistryName(name);
            this.func_77637_a(NotEnoughWands.tabNew);
            GameRegistry.register((IForgeRegistryEntry)this);
            wands.add(this);
        }
        return this;
    }

    GenericWand xpUsage(int xp) {
        this.needsxp = xp;
        return this;
    }

    GenericWand rfUsage(int maxrf, int rf) {
        this.maxrf = maxrf;
        this.needsrf = rf;
        return this;
    }

    GenericWand durabilityUsage(int maxdurability) {
        this.func_77656_e(maxdurability);
        return this;
    }

    GenericWand loot(int rarity) {
        this.lootRarity = rarity;
        return this;
    }

    GenericWand availability(int availability) {
        this.availability = availability;
        return this;
    }

    protected String getConfigPrefix() {
        return this.getRegistryName().func_110623_a();
    }

    public void initConfig(Configuration cfg) {
        this.needsxp = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
        this.needsrf = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
        this.maxrf = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
        this.func_77656_e(cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxdurability", this.func_77612_l(), "Maximum durability for this wand").getInt());
        this.availability = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_availability", this.availability, "Is this wand available? (0=no, 1=not craftable, 2=craftable advanced, 3=craftable normal)").getInt();
        this.lootRarity = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_lootRarity", this.lootRarity, "How rare should this wand be in chests? Lower is more rare (0 is not in chests)").getInt();
    }

    protected boolean checkUsage(ItemStack stack, EntityPlayer player, float difficultyScale) {
        int experience;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (this.needsxp > 0 && (experience = Tools.getPlayerXP(player) - (int)((float)this.needsxp * difficultyScale)) <= 0) {
            Tools.error(player, "Not enough experience!");
            return false;
        }
        if (this.func_77645_m() && stack.func_77952_i() >= stack.func_77958_k()) {
            Tools.error(player, "This wand can no longer be used!");
            return false;
        }
        if (this.needsrf > 0 && this.getEnergyStored(stack) < (int)((float)this.needsrf * difficultyScale)) {
            Tools.error(player, "Not enough energy to use this wand!");
            return false;
        }
        return true;
    }

    protected void registerUsage(ItemStack stack, EntityPlayer player, float difficultyScale) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.needsxp > 0) {
            Tools.addPlayerXP(player, -((int)((float)this.needsxp * difficultyScale)));
        }
        if (this.func_77645_m()) {
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        if (this.needsrf > 0) {
            this.extractEnergy(stack, (int)((float)this.needsrf * difficultyScale), false);
        }
    }

    public void toggleMode(EntityPlayer player, ItemStack stack) {
    }

    public void toggleSubMode(EntityPlayer player, ItemStack stack) {
    }

    @SideOnly(value=Side.CLIENT)
    public static void setupModels() {
        for (GenericWand wand : wands) {
            wand.registerModel();
        }
    }

    public static void setupCrafting() {
        for (GenericWand wand : wands) {
            if (wand.availability == AVAILABILITY_NORMAL) {
                wand.setupCraftingInt(ModItems.wandCore);
                continue;
            }
            if (wand.availability != AVAILABILITY_ADVANCED) continue;
            wand.setupCraftingInt(ModItems.advancedWandCore);
        }
    }

    public static void setupConfig(Configuration cfg) {
        for (GenericWand wand : wands) {
            wand.initConfig(cfg);
        }
    }

    protected void setupCraftingInt(Item wandcore) {
    }

    public static void setupChestLoot(LootPool main) {
        for (GenericWand wand : wands) {
            wand.setupChestLootInt(main);
        }
    }

    private void setupChestLootInt(LootPool main) {
        if (this.lootRarity > 0 && this.availability > 0) {
            String entryName = "notenoughwands:" + this.getRegistryName().func_110623_a();
            main.addEntry((LootEntry)new LootEntryItem((Item)this, this.lootRarity, 0, new LootFunction[0], new LootCondition[0], entryName));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityPlayerSP player, ItemStack wand) {
    }

    protected static void renderOutlines(RenderWorldLastEvent evt, EntityPlayerSP p, Set<BlockPos> coordinates, int r, int g, int b) {
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GenericWand.renderOutlines(coordinates, r, g, b, 4);
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        GlStateManager.func_179098_w();
    }

    protected void showModeKeyDescription(List<String> list, String suffix) {
        String keyDescription = KeyBindings.wandModifier.getDisplayName();
        list.add("Mode key (" + keyDescription + ") to " + suffix);
    }

    protected void showSubModeKeyDescription(List<String> list, String suffix) {
        String keyDescription = KeyBindings.wandSubMode.getDisplayName();
        list.add("Sub-mode key (" + keyDescription + ") to " + suffix);
    }

    private static void renderOutlines(Set<BlockPos> coordinates, int r, int g, int b, int thickness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        GL11.glLineWidth((float)thickness);
        for (BlockPos coordinate : coordinates) {
            float x = coordinate.func_177958_n();
            float y = coordinate.func_177956_o();
            float z = coordinate.func_177952_p();
            GenericWand.renderHighLightedBlocksOutline(buffer, x, y, z, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
        }
        tessellator.func_78381_a();
    }

    public static void renderHighLightedBlocksOutline(VertexBuffer buffer, float mx, float my, float mz, float r, float g, float b, float a) {
        buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
    }

    private static void renderBlockOutline(VertexBuffer buffer, float mx, float my, float mz, float o) {
        buffer.func_181662_b((double)(mx - o), (double)(my - o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my - o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx - o), (double)(my - o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx - o), (double)(my + 1.0f + o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx - o), (double)(my - o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx - o), (double)(my - o), (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)(mx - o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my - o), (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx - o), (double)(my + 1.0f + o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx - o), (double)(my + 1.0f + o), (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)(mx - o), (double)(my + 1.0f + o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my - o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my - o), (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my - o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)(my + 1.0f + o), (double)(mz - o)).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f + o), (double)my, (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f + o)).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f + o), (double)(mz + 1.0f + o)).func_181675_d();
    }

    @Optional.Method(modid="CoFHAPI")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (this.maxrf <= 0) {
            return 0;
        }
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.needsrf, maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Optional.Method(modid="CoFHAPI")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (this.maxrf <= 0) {
            return 0;
        }
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.maxrf - energy, Math.min(this.maxrf, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Optional.Method(modid="CoFHAPI")
    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    @Optional.Method(modid="CoFHAPI")
    public int getMaxEnergyStored(ItemStack container) {
        return this.maxrf;
    }
}

