/*
 * Decompiled with CFR 0.152.
 */
package reborncore.jtraits;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import reborncore.jtraits.ClassLoadingHelper;
import reborncore.jtraits.Mixin;

public class ASMUtils {
    private static Map<Integer, String> opcodes = new HashMap<Integer, String>();
    private static NodeCopier copier;

    public static String getOpcode(int opcode) {
        return opcodes.get(opcode);
    }

    public static int addInstructionsWithSuperRedirections(AbstractInsnNode node, List<AbstractInsnNode> added, int supercall, Mixin<?> mixin) {
        if (node instanceof FieldInsnNode) {
            FieldInsnNode f = (FieldInsnNode)node;
            if (ASMUtils.matches(f.owner, mixin.getTraitType())) {
                if (f.name.equals("_super")) {
                    added.add((AbstractInsnNode)new TypeInsnNode(192, mixin.getNewType()));
                    return 1;
                }
                added.add((AbstractInsnNode)new FieldInsnNode(f.getOpcode(), mixin.getNewType(), f.name, f.desc));
                if (f.name.equals("_self")) {
                    return 3;
                }
            } else {
                added.add((AbstractInsnNode)new FieldInsnNode(f.getOpcode(), f.owner, f.name, f.desc));
            }
        } else if (node instanceof MethodInsnNode) {
            MethodInsnNode m = (MethodInsnNode)node;
            if (supercall == 1 && !m.name.equals("<init>") && !m.name.equals("<clinit>") && ASMUtils.matches(m.owner, mixin.getParents())) {
                added.add((AbstractInsnNode)new MethodInsnNode(183, ASMUtils.trackClosestImplementation(m.name, m.desc, mixin.getParentClass()), m.name, m.desc, false));
                return 2;
            }
            if (supercall == 3 && !m.name.equals("<init>") && !m.name.equals("<clinit>") && ASMUtils.matches(m.owner, mixin.getParents())) {
                added.add((AbstractInsnNode)new MethodInsnNode(m.itf ? 185 : 183, m.owner, m.name, m.desc, m.itf));
                return 2;
            }
            if (ASMUtils.matches(m.owner, mixin.getParents())) {
                added.add((AbstractInsnNode)new MethodInsnNode(m.getOpcode(), mixin.getNewType(), m.name, m.desc, m.itf));
            } else {
                added.add((AbstractInsnNode)new MethodInsnNode(m.getOpcode(), m.owner, m.name, m.desc, m.itf));
            }
        } else if (node instanceof TypeInsnNode) {
            TypeInsnNode t = (TypeInsnNode)node;
            if (ASMUtils.matches(t.desc, mixin.getParents())) {
                added.add((AbstractInsnNode)new TypeInsnNode(t.getOpcode(), mixin.getNewType()));
            } else {
                added.add((AbstractInsnNode)new TypeInsnNode(t.getOpcode(), t.desc));
            }
        } else if (node instanceof VarInsnNode) {
            VarInsnNode v = (VarInsnNode)node;
            if (v.var == 0) {
                added.add((AbstractInsnNode)new VarInsnNode(v.getOpcode(), v.var));
                added.add((AbstractInsnNode)new TypeInsnNode(192, mixin.getNewType()));
            }
        }
        return 0;
    }

    public static String nodeToString(AbstractInsnNode node) {
        String str = "[" + ASMUtils.getOpcode(node.getOpcode()) + "] ";
        if (node instanceof FieldInsnNode) {
            FieldInsnNode n = (FieldInsnNode)node;
            str = str + "VARIABLE: owner=\"" + n.owner + "\" name=\"" + n.name + "\" desc=\"" + n.desc + "\"";
        } else if (node instanceof MethodInsnNode) {
            MethodInsnNode n = (MethodInsnNode)node;
            str = str + "METHOD: owner=\"" + n.owner + "\" name=\"" + n.name + "\" desc=\"" + n.desc + "\"";
        } else if (node instanceof TypeInsnNode) {
            TypeInsnNode n = (TypeInsnNode)node;
            str = str + "TYPE: desc=\"" + n.desc + "\"";
        } else if (node instanceof VarInsnNode) {
            VarInsnNode n = (VarInsnNode)node;
            str = str + "VAR: " + n.var;
        } else if (node instanceof LdcInsnNode) {
            LdcInsnNode n = (LdcInsnNode)node;
            str = str + "CONSTANT: \"" + n.cst + "\"";
        } else if (node instanceof LabelNode) {
            LabelNode n = (LabelNode)node;
            str = str + "LABEL: " + n.getLabel() + " - " + n.getLabel().hashCode();
        } else if (node instanceof JumpInsnNode) {
            JumpInsnNode n = (JumpInsnNode)node;
            str = str + "JUMP: " + n.label.getLabel() + " - " + n.label.getLabel().hashCode();
        } else if (node instanceof LineNumberNode) {
            LineNumberNode n = (LineNumberNode)node;
            str = str + "LINE: " + n.line;
        } else if (node instanceof FrameNode) {
            FrameNode n = (FrameNode)node;
            str = str + "FRAME: " + n.type;
        } else {
            str = node instanceof InsnNode ? ASMUtils.getOpcode(node.getOpcode()) : str + node;
        }
        return str;
    }

    public static boolean matches(String str, String ... others) {
        for (String s : others) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static ClassNode getClassNode(Class<?> clazz) {
        try {
            ClassNode cnode = new ClassNode();
            ClassReader reader = new ClassReader(ClassLoadingHelper.instance.getResourceAsStream(clazz.getName().replace(".", "/") + ".class"));
            reader.accept((ClassVisitor)cnode, 0);
            return cnode;
        }
        catch (IOException ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    public static ClassNode getClassNode(byte[] bytecode) {
        ClassNode cnode = new ClassNode();
        ClassReader reader = new ClassReader(bytecode);
        reader.accept((ClassVisitor)cnode, 0);
        return cnode;
    }

    public static int getReturnCode(String type) {
        if (type.equals("V")) {
            return 177;
        }
        if (type.equals("B") || type.equals("Z") || type.equals("S") || type.equals("I")) {
            return 172;
        }
        if (type.equals("L")) {
            return 173;
        }
        if (type.equals("F")) {
            return 174;
        }
        if (type.equals("D")) {
            return 175;
        }
        return 176;
    }

    public static String[] recursivelyFindClasses(Mixin<?> mixin) {
        HashSet<String> set = new HashSet<String>();
        ASMUtils.recursivelyFindClasses(mixin, set);
        return set.toArray(new String[set.size()]);
    }

    private static void recursivelyFindClasses(Mixin<?> mixin, Set<String> set) {
        set.add(mixin.getParentType());
        set.add(mixin.getTraitType());
        ASMUtils.recursivelyFindClasses(set);
        Mixin<?> next = ClassLoadingHelper.instance.findMixin(mixin.getParentType().replace("/", "."));
        if (next != null) {
            ASMUtils.recursivelyFindClasses(next, set);
        }
    }

    private static void recursivelyFindClasses(Set<String> set) {
        int oldAmt = set.size();
        for (String s : new ArrayList<String>(set)) {
            try {
                Class<?> c = Class.forName(s.replace('/', '.'));
                Class<?> sc = c.getSuperclass();
                if (sc != null) {
                    set.add(sc.getName().replace('.', '/'));
                }
                for (Class<?> i : c.getInterfaces()) {
                    set.add(i.getName().replace('.', '/'));
                }
            }
            catch (Exception exception) {
            }
        }
        if (oldAmt != set.size()) {
            ASMUtils.recursivelyFindClasses(set);
        }
    }

    public static MethodNode getMethod(String name, String desc, ClassNode clazz) {
        for (MethodNode m : clazz.methods) {
            if (!m.name.equals(name) || !m.desc.equals(desc)) continue;
            return m;
        }
        return null;
    }

    public static void resetCopy(InsnList srcList) {
        copier = new NodeCopier(srcList);
    }

    public static void copyInsn(InsnList destList, AbstractInsnNode insn) {
        if (insn == null) {
            return;
        }
        copier.copyTo(insn, destList);
    }

    public static String trackClosestImplementation(String name, String desc, Class<?> clazz) {
        if (clazz == Object.class) {
            return null;
        }
        ClassNode n = ASMUtils.getClassNode(clazz);
        for (MethodNode m : n.methods) {
            if (!m.name.equals(name) || !m.desc.equals(desc)) continue;
            return Type.getInternalName(clazz);
        }
        return ASMUtils.trackClosestImplementation(name, desc, clazz.getSuperclass());
    }

    static {
        for (Field f : Opcodes.class.getFields()) {
            f.setAccessible(true);
            try {
                opcodes.put(f.getInt(null), f.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class NodeCopier {
        private Map<LabelNode, LabelNode> labelMap = Maps.newHashMap();

        public NodeCopier(InsnList sourceList) {
            for (AbstractInsnNode instruction = sourceList.getFirst(); instruction != null; instruction = instruction.getNext()) {
                if (!(instruction instanceof LabelNode)) continue;
                this.labelMap.put((LabelNode)instruction, new LabelNode());
            }
        }

        public void copyTo(AbstractInsnNode node, InsnList destination) {
            if (node == null) {
                return;
            }
            if (destination == null) {
                return;
            }
            destination.add(node.clone(this.labelMap));
        }
    }
}

