/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.minetweaker;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.commons.io.FileUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

public class MinetweakerDocGen {
    public static void gen(ASMDataTable dataTable, File exportFile) {
        long start = System.currentTimeMillis();
        if (exportFile.exists()) {
            exportFile.delete();
        }
        StringBuilder builder = new StringBuilder();
        String newline = System.getProperty("line.separator");
        ArrayList<String> lines = new ArrayList<String>();
        Set asmDataSet = dataTable.getAll(ZenClass.class.getCanonicalName());
        for (ASMDataTable.ASMData asmData : asmDataSet) {
            String prefix;
            if (asmData.getAnnotationInfo().size() == 0 || (prefix = (String)asmData.getAnnotationInfo().get("value")).startsWith("minetweaker")) continue;
            try {
                Class<?> clazz = Class.forName(asmData.getClassName());
                if (clazz.getMethods().length == 0) continue;
                for (Method method : clazz.getMethods()) {
                    if (!method.isAnnotationPresent(ZenMethod.class)) continue;
                    StringBuilder parameter = new StringBuilder();
                    parameter.append("(");
                    for (int i = 0; i < method.getParameterTypes().length; ++i) {
                        Class<?> param = method.getParameterTypes()[i];
                        parameter.append(param.getSimpleName());
                        if (i + 1 == method.getParameterTypes().length) continue;
                        parameter.append(", ");
                    }
                    parameter.append(")");
                    lines.add(prefix + "." + method.getName() + parameter.toString());
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(lines);
        for (String line : lines) {
            builder.append(line);
            builder.append(newline);
        }
        builder.append("Generated by reborn core in " + (System.currentTimeMillis() - start) + "ms");
        try {
            FileUtils.writeStringToFile((File)exportFile, (String)builder.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

