/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemDye;
import net.minecraft.util.math.MathHelper;

public class ColorButton
extends IconButton {
    private int colorIndex = 0;
    private String tooltipPrefix = "";

    public ColorButton(IGuiScreen gui, int id, int x, int y) {
        super(gui, id, x, y, null);
    }

    @Override
    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        boolean result = super.func_146116_c(par1Minecraft, par2, par3);
        if (result) {
            this.nextColor();
        }
        return result;
    }

    @Override
    public boolean mousePressedButton(Minecraft mc, int x, int y, int button) {
        boolean result;
        boolean bl = result = button == 1 && super.checkMousePress(mc, x, y);
        if (result) {
            this.prevColor();
        }
        return result;
    }

    public String getTooltipPrefix() {
        return this.tooltipPrefix;
    }

    public void setToolTipHeading(String tooltipPrefix) {
        this.tooltipPrefix = tooltipPrefix == null ? "" : tooltipPrefix;
    }

    private void nextColor() {
        ++this.colorIndex;
        if (this.colorIndex >= ItemDye.field_150922_c.length) {
            this.colorIndex = 0;
        }
        this.setColorIndex(this.colorIndex);
    }

    private void prevColor() {
        --this.colorIndex;
        if (this.colorIndex < 0) {
            this.colorIndex = ItemDye.field_150922_c.length - 1;
        }
        this.setColorIndex(this.colorIndex);
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = MathHelper.func_76125_a((int)colorIndex, (int)0, (int)(ItemDye.field_150922_c.length - 1));
        String colStr = DyeColor.values()[colorIndex].getLocalisedName();
        if (this.tooltipPrefix != null && this.tooltipPrefix.length() > 0) {
            this.setToolTip(this.tooltipPrefix, colStr);
        } else {
            this.setToolTip(colStr);
        }
    }

    @Override
    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        super.func_146112_a(mc, mouseX, mouseY);
        if (this.field_146125_m) {
            VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
            tes.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int x = this.field_146128_h + 2;
            int y = this.field_146129_i + 2;
            GlStateManager.func_179090_x();
            int col = ItemDye.field_150922_c[this.colorIndex];
            Vector3f c = ColorUtil.toFloat(col);
            GlStateManager.func_179124_c((float)c.x, (float)c.y, (float)c.z);
            tes.func_181662_b((double)x, (double)(y + this.field_146121_g - 4), (double)this.field_73735_i).func_181666_a(c.x, c.y, c.z, 1.0f).func_181675_d();
            tes.func_181662_b((double)(x + this.field_146120_f - 4), (double)(y + this.field_146121_g - 4), (double)this.field_73735_i).func_181666_a(c.x, c.y, c.z, 1.0f).func_181675_d();
            tes.func_181662_b((double)(x + this.field_146120_f - 4), (double)(y + 0), (double)this.field_73735_i).func_181666_a(c.x, c.y, c.z, 1.0f).func_181675_d();
            tes.func_181662_b((double)x, (double)(y + 0), (double)this.field_73735_i).func_181666_a(c.x, c.y, c.z, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179098_w();
        }
    }
}

