/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.externalstorage;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageExternal;
import com.raoulvdberge.refinedstorage.tile.externalstorage.TileExternalStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStorageItemHandler
extends ItemStorageExternal {
    private TileExternalStorage externalStorage;
    private Supplier<IItemHandler> handlerSupplier;
    private AccessType lockedAccessType = AccessType.INSERT_EXTRACT;

    public ItemStorageItemHandler(TileExternalStorage externalStorage, Supplier<IItemHandler> handlerSupplier) {
        this.externalStorage = externalStorage;
        this.handlerSupplier = handlerSupplier;
        if (externalStorage.getFacingTile().func_145838_q().func_149739_a().equals("tile.ExtraUtils2:TrashCan")) {
            this.lockedAccessType = AccessType.INSERT;
        }
    }

    @Override
    public int getCapacity() {
        IItemHandler handler = this.handlerSupplier.get();
        return handler != null ? handler.getSlots() * 64 : 0;
    }

    @Override
    public List<ItemStack> getStacks() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slot = handler.getStackInSlot(i);
            items.add(slot != null ? slot.func_77946_l() : null);
        }
        return items;
    }

    @Override
    public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
        if (IFilterable.canTake((IItemHandler)this.externalStorage.getItemFilters(), this.externalStorage.getMode(), this.externalStorage.getCompare(), stack)) {
            return ItemHandlerHelper.insertItem((IItemHandler)this.handlerSupplier.get(), (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), (boolean)simulate);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    @Override
    public ItemStack extractItem(ItemStack stack, int size, int flags, boolean simulate) {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return null;
        }
        int remaining = size;
        ItemStack received = null;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack got;
            ItemStack slot = handler.getStackInSlot(i);
            if (slot == null || !API.instance().getComparer().isEqual(slot, stack, flags) || (got = handler.extractItem(i, remaining, simulate)) == null) continue;
            if (received == null) {
                received = got;
            } else {
                received.field_77994_a += got.field_77994_a;
            }
            if ((remaining -= got.field_77994_a) == 0) break;
        }
        return received;
    }

    @Override
    public int getStored() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slot = handler.getStackInSlot(i);
            if (slot == null) continue;
            size += slot.field_77994_a;
        }
        return size;
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.lockedAccessType != AccessType.INSERT_EXTRACT ? this.lockedAccessType : this.externalStorage.getAccessType();
    }
}

