/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.externalstorage;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageExternal;
import com.raoulvdberge.refinedstorage.tile.externalstorage.TileExternalStorage;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class ItemStorageDSU
extends ItemStorageExternal {
    private TileExternalStorage externalStorage;
    private Supplier<IDeepStorageUnit> dsuSupplier;

    public ItemStorageDSU(TileExternalStorage externalStorage, Supplier<IDeepStorageUnit> dsuSupplier) {
        this.externalStorage = externalStorage;
        this.dsuSupplier = dsuSupplier;
    }

    @Override
    public int getCapacity() {
        IDeepStorageUnit dsu = this.dsuSupplier.get();
        return dsu != null ? dsu.getMaxStoredCount() : 0;
    }

    @Override
    public List<ItemStack> getStacks() {
        ItemStack stored;
        IDeepStorageUnit dsu = this.dsuSupplier.get();
        if (dsu != null && (stored = dsu.getStoredItemType()) != null && stored.field_77994_a > 0) {
            return Collections.singletonList(stored.func_77946_l());
        }
        return Collections.emptyList();
    }

    @Override
    public ItemStack insertItem(@Nonnull ItemStack stack, int size, boolean simulate) {
        IDeepStorageUnit dsu = this.dsuSupplier.get();
        if (dsu != null && IFilterable.canTake((IItemHandler)this.externalStorage.getItemFilters(), this.externalStorage.getMode(), this.externalStorage.getCompare(), stack)) {
            if (dsu.getStoredItemType() != null) {
                if (API.instance().getComparer().isEqualNoQuantity(dsu.getStoredItemType(), stack)) {
                    if (this.getStored() + size > dsu.getMaxStoredCount()) {
                        int remainingSpace = this.getCapacity() - this.getStored();
                        if (remainingSpace <= 0) {
                            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                        }
                        if (!simulate) {
                            dsu.setStoredItemCount(dsu.getStoredItemType().field_77994_a + remainingSpace);
                        }
                        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
                    }
                    if (!simulate) {
                        dsu.setStoredItemCount(dsu.getStoredItemType().field_77994_a + size);
                    }
                    return null;
                }
            } else {
                if (this.getStored() + size > dsu.getMaxStoredCount()) {
                    int remainingSpace = this.getCapacity() - this.getStored();
                    if (remainingSpace <= 0) {
                        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                    }
                    if (!simulate) {
                        dsu.setStoredItemType(stack.func_77946_l(), remainingSpace);
                    }
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
                }
                if (!simulate) {
                    dsu.setStoredItemType(stack.func_77946_l(), size);
                }
                return null;
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    @Override
    public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        IDeepStorageUnit dsu = this.dsuSupplier.get();
        if (dsu != null && API.instance().getComparer().isEqual(stack, dsu.getStoredItemType(), flags)) {
            ItemStack stored = dsu.getStoredItemType();
            if (size > stored.field_77994_a) {
                size = stored.field_77994_a;
            }
            if (!simulate) {
                dsu.setStoredItemCount(stored.field_77994_a - size);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stored, (int)size);
        }
        return null;
    }

    @Override
    public int getStored() {
        ItemStack stored;
        IDeepStorageUnit dsu = this.dsuSupplier.get();
        if (dsu != null && (stored = dsu.getStoredItemType()) != null) {
            return stored.field_77994_a;
        }
        return 0;
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.externalStorage.getAccessType();
    }
}

