/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.integration.cyclopscore.SlotlessItemHandlerHelper;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageExternal;
import com.raoulvdberge.refinedstorage.tile.externalstorage.TileExternalStorage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.inventory.IndexedSlotlessItemHandlerWrapper;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.tileentity.InventoryTileEntityBase;

public class ItemStorageCyclops
extends ItemStorageExternal {
    private TileExternalStorage externalStorage;
    private EnumFacing opposite;
    private Supplier<InventoryTileEntityBase> cyclopsInv;
    private int oldInventoryHash = -1;

    public ItemStorageCyclops(TileExternalStorage externalStorage) {
        this.externalStorage = externalStorage;
        this.opposite = externalStorage.getDirection().func_176734_d();
        this.cyclopsInv = () -> {
            TileEntity f = externalStorage.getFacingTile();
            return f instanceof InventoryTileEntityBase ? (InventoryTileEntityBase)f : null;
        };
    }

    @Override
    public void detectChanges(INetworkMaster network) {
        int inventoryHash;
        InventoryTileEntityBase inv = this.cyclopsInv.get();
        if (inv != null && (inventoryHash = inv.getInventoryHash()) != this.oldInventoryHash) {
            super.detectChanges(network);
            this.oldInventoryHash = inventoryHash;
        }
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.getStacks(this.cyclopsInv.get());
    }

    @Override
    public int getStored() {
        return this.getStacks(this.cyclopsInv.get()).stream().mapToInt(s -> s.field_77994_a).sum();
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }

    @Override
    public int getCapacity() {
        InventoryTileEntityBase inv = this.cyclopsInv.get();
        return inv != null ? inv.getInventory().func_70302_i_() * 64 : 0;
    }

    @Override
    @Nullable
    public ItemStack insertItem(@Nonnull ItemStack stack, int size, boolean simulate) {
        InventoryTileEntityBase inv = this.cyclopsInv.get();
        if (inv != null && IFilterable.canTake((IItemHandler)this.externalStorage.getItemFilters(), this.externalStorage.getMode(), this.externalStorage.getCompare(), stack)) {
            return SlotlessItemHandlerHelper.insertItem((TileEntity)inv, this.opposite, stack, size, simulate);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    @Override
    @Nullable
    public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        InventoryTileEntityBase inv = this.cyclopsInv.get();
        return inv != null ? SlotlessItemHandlerHelper.extractItem((TileEntity)inv, this.opposite, stack, size, flags, simulate) : null;
    }

    private List<ItemStack> getStacks(@Nullable InventoryTileEntityBase inv) {
        if (inv != null) {
            if (inv.getInventory() instanceof IndexedSlotlessItemHandlerWrapper.IInventoryIndexReference) {
                return ((IndexedSlotlessItemHandlerWrapper.IInventoryIndexReference)inv.getInventory()).getIndex().values().stream().flatMap(m -> m.valueCollection().stream()).map(ItemStack::func_77946_l).collect(Collectors.toList());
            }
            return Arrays.stream(((SimpleInventory)inv.getInventory()).getItemStacks()).map(ItemStack::func_77946_l).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean isValid(TileEntity facingTE, EnumFacing facing) {
        return facingTE instanceof InventoryTileEntityBase && (SlotlessItemHandlerHelper.isSlotless(facingTE, facing) || ((InventoryTileEntityBase)facingTE).getInventory() instanceof SimpleInventory);
    }
}

