/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGridItemDelta
implements IMessage,
IMessageHandler<MessageGridItemDelta, IMessage> {
    private INetworkMaster network;
    private ItemStack stack;
    private int delta;
    private GridStackItem clientStack;

    public MessageGridItemDelta() {
    }

    public MessageGridItemDelta(INetworkMaster network, ItemStack stack, int delta) {
        this.network = network;
        this.stack = stack;
        this.delta = delta;
    }

    public void fromBytes(ByteBuf buf) {
        this.clientStack = new GridStackItem(buf);
        this.clientStack.getStack().field_77994_a = this.delta = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        RSUtils.writeItemStack(buf, this.stack, this.network);
        buf.writeInt(this.delta);
    }

    public IMessage onMessage(MessageGridItemDelta message, MessageContext ctx) {
        Item item = message.clientStack.getStack().func_77973_b();
        for (GridStackItem stack : GuiGrid.ITEMS.get((Object)item)) {
            if (!stack.equals(message.clientStack)) continue;
            if (stack.getStack().field_77994_a + message.delta == 0 && !message.clientStack.isCraftable()) {
                GuiGrid.ITEMS.remove((Object)item, (Object)stack);
            } else {
                stack.getStack().field_77994_a += message.delta;
            }
            GuiGrid.markForSorting();
            return null;
        }
        GuiGrid.ITEMS.put((Object)item, (Object)message.clientStack);
        GuiGrid.markForSorting();
        return null;
    }
}

