/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.apiimpl.storage.fluid.FluidStorageNBT;
import com.raoulvdberge.refinedstorage.block.EnumFluidStorageType;
import com.raoulvdberge.refinedstorage.item.ItemBlockBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemBlockFluidStorage
extends ItemBlockBase {
    public ItemBlockFluidStorage() {
        super(RSBlocks.FLUID_STORAGE, RSBlocks.FLUID_STORAGE.getPlacementType(), true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        EnumFluidStorageType type = EnumFluidStorageType.getById(stack.func_77960_j());
        if (type != null && ItemBlockFluidStorage.isValid(stack)) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("Storage");
            if (type == EnumFluidStorageType.TYPE_CREATIVE) {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{FluidStorageNBT.getStoredFromNBT(tag)}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{FluidStorageNBT.getStoredFromNBT(tag), type.getCapacity()}));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        EnumFluidStorageType type = EnumFluidStorageType.getById(stack.func_77960_j());
        if (type != null && stack.field_77994_a == 1 && ItemBlockFluidStorage.isValid(stack) && FluidStorageNBT.getStoredFromNBT(stack.func_77978_p().func_74775_l("Storage")) <= 0 && stack.func_77960_j() != 4 && !world.field_72995_K && player.func_70093_af()) {
            ItemStack processor;
            ItemStack storagePart = new ItemStack((Item)RSItems.FLUID_STORAGE_PART, 1, stack.func_77960_j());
            if (!player.field_71071_by.func_70441_a(storagePart.func_77946_l())) {
                InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)storagePart);
            }
            if (!player.field_71071_by.func_70441_a((processor = new ItemStack((Item)RSItems.PROCESSOR, 1, 3)).func_77946_l())) {
                InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)processor);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Block)RSBlocks.MACHINE_CASING));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private static boolean isValid(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Storage");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!stack.func_77942_o()) {
            ItemBlockFluidStorage.initNBT(stack);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        ItemBlockFluidStorage.initNBT(stack);
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (!ItemBlockFluidStorage.isValid(stack)) {
            return super.getNBTShareTag(stack);
        }
        NBTTagCompound shareTag = new NBTTagCompound();
        shareTag.func_74782_a("Storage", (NBTBase)FluidStorageNBT.getNBTShareTag(stack.func_77978_p().func_74775_l("Storage")));
        return shareTag;
    }

    public static ItemStack initNBT(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Storage", (NBTBase)FluidStorageNBT.createNBT());
        stack.func_77982_d(tag);
        return stack;
    }
}

