/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.gui.grid.GridFilter;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerGridFilter;
import com.raoulvdberge.refinedstorage.inventory.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.item.ItemGridFilter;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ItemHandlerGridFilterInGrid
extends ItemHandlerBasic {
    private List<GridFilter> filteredItems;

    public ItemHandlerGridFilterInGrid(List<GridFilter> filteredItems) {
        super(4, new ItemValidatorBasic(RSItems.GRID_FILTER));
        this.filteredItems = filteredItems;
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.filteredItems.clear();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack filter = this.getStackInSlot(i);
            if (filter == null) continue;
            int compare = ItemGridFilter.getCompare(filter);
            ItemHandlerGridFilter items = new ItemHandlerGridFilter(filter);
            for (ItemStack item : items.getFilteredItems()) {
                if (item == null) continue;
                this.filteredItems.add(new GridFilter(item, compare));
            }
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            GuiGrid.markForSorting();
        }
    }
}

