/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.stack;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class GridStackFluid
implements IGridStack {
    private int hash;
    private FluidStack stack;

    public GridStackFluid(Pair<Integer, FluidStack> data) {
        this.hash = (Integer)data.getLeft();
        this.stack = (FluidStack)data.getRight();
    }

    public FluidStack getStack() {
        return this.stack;
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public String getName() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public String getModId() {
        return this.stack.getFluid().getStill(this.stack).func_110624_b();
    }

    @Override
    public String[] getOreIds() {
        return new String[]{this.stack.getFluid().getName()};
    }

    @Override
    public String getTooltip() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public int getQuantity() {
        return this.stack.amount;
    }

    @Override
    public void draw(GuiBase gui, int x, int y, boolean isOverWithShift) {
        GuiBase.FLUID_RENDERER.draw(gui.field_146297_k, x, y, this.stack);
        gui.drawQuantity(x, y, RSUtils.QUANTITY_FORMATTER.format((float)this.stack.amount / 1000.0f));
    }

    @Override
    public Object getIngredient() {
        return this.stack;
    }

    public boolean equals(Object obj) {
        return obj instanceof GridStackFluid && ((GridStackFluid)obj).getStack().isFluidEqual(this.stack);
    }
}

