/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.item;

import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorage;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemStorageNBT
implements IItemStorage {
    private static final int PROTOCOL = 1;
    private static final String NBT_PROTOCOL = "Protocol";
    private static final String NBT_ITEMS = "Items";
    private static final String NBT_STORED = "Stored";
    private static final String NBT_ITEM_TYPE = "Type";
    private static final String NBT_ITEM_QUANTITY = "Quantity";
    private static final String NBT_ITEM_DAMAGE = "Damage";
    private static final String NBT_ITEM_NBT = "NBT";
    private static final String NBT_ITEM_CAPS = "Caps";
    private NBTTagCompound tag;
    private int capacity;
    private TileEntity tile;
    private List<ItemStack> stacks = new ArrayList<ItemStack>();

    public ItemStorageNBT(NBTTagCompound tag, int capacity, @Nullable TileEntity tile) {
        this.tag = tag;
        this.capacity = capacity;
        this.tile = tile;
        this.readFromNBT();
    }

    private void readFromNBT() {
        NBTTagList list = (NBTTagList)this.tag.func_74781_a(NBT_ITEMS);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack stack = new ItemStack(Item.func_150899_d((int)tag.func_74762_e(NBT_ITEM_TYPE)), tag.func_74762_e(NBT_ITEM_QUANTITY), tag.func_74762_e(NBT_ITEM_DAMAGE), tag.func_74764_b(NBT_ITEM_CAPS) ? tag.func_74775_l(NBT_ITEM_CAPS) : null);
            stack.func_77982_d(tag.func_74764_b(NBT_ITEM_NBT) ? tag.func_74775_l(NBT_ITEM_NBT) : null);
            if (stack.func_77973_b() == null) continue;
            this.stacks.add(stack);
        }
    }

    private ItemStack safeCopy(ItemStack stack, int size) {
        ItemStack newStack = stack.func_77946_l();
        newStack.field_77994_a = size;
        return newStack;
    }

    public void writeToNBT() {
        NBTTagList list = new NBTTagList();
        NBTTagCompound dummy = new NBTTagCompound();
        for (ItemStack stack : this.stacks) {
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a(NBT_ITEM_TYPE, Item.func_150891_b((Item)stack.func_77973_b()));
            itemTag.func_74768_a(NBT_ITEM_QUANTITY, stack.field_77994_a);
            itemTag.func_74768_a(NBT_ITEM_DAMAGE, stack.func_77952_i());
            if (stack.func_77942_o()) {
                itemTag.func_74782_a(NBT_ITEM_NBT, (NBTBase)stack.func_77978_p());
            }
            stack.func_77955_b(dummy);
            if (dummy.func_74764_b("ForgeCaps")) {
                itemTag.func_74782_a(NBT_ITEM_CAPS, dummy.func_74781_a("ForgeCaps"));
            }
            dummy.func_82580_o("ForgeCaps");
            list.func_74742_a((NBTBase)itemTag);
        }
        this.tag.func_74782_a(NBT_ITEMS, (NBTBase)list);
        this.tag.func_74768_a(NBT_PROTOCOL, 1);
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    @Override
    public synchronized ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
        for (ItemStack otherStack : this.stacks) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                }
                if (!simulate) {
                    this.tag.func_74768_a(NBT_STORED, this.getStored() + remainingSpace);
                    otherStack.field_77994_a += remainingSpace;
                    this.onStorageChanged();
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)(size - remainingSpace));
            }
            if (!simulate) {
                this.tag.func_74768_a(NBT_STORED, this.getStored() + size);
                otherStack.field_77994_a += size;
                this.onStorageChanged();
            }
            return null;
        }
        if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
            int remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            if (!simulate) {
                this.tag.func_74768_a(NBT_STORED, this.getStored() + remainingSpace);
                this.stacks.add(this.safeCopy(stack, remainingSpace));
                this.onStorageChanged();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
        }
        if (!simulate) {
            this.tag.func_74768_a(NBT_STORED, this.getStored() + size);
            this.stacks.add(this.safeCopy(stack, size));
            this.onStorageChanged();
        }
        return null;
    }

    @Override
    public synchronized ItemStack extractItem(ItemStack stack, int size, int flags, boolean simulate) {
        for (ItemStack otherStack : this.stacks) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            if (size > otherStack.field_77994_a) {
                size = otherStack.field_77994_a;
            }
            if (!simulate) {
                if (otherStack.field_77994_a - size == 0) {
                    this.stacks.remove(otherStack);
                } else {
                    otherStack.field_77994_a -= size;
                }
                this.tag.func_74768_a(NBT_STORED, this.getStored() - size);
                this.onStorageChanged();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)size);
        }
        return null;
    }

    public void onStorageChanged() {
        if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }

    @Override
    public int getStored() {
        return ItemStorageNBT.getStoredFromNBT(this.tag);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isFull() {
        return this.getStored() == this.getCapacity();
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    public static int getStoredFromNBT(NBTTagCompound tag) {
        return tag.func_74762_e(NBT_STORED);
    }

    public static NBTTagCompound getNBTShareTag(NBTTagCompound tag) {
        NBTTagCompound otherTag = new NBTTagCompound();
        otherTag.func_74768_a(NBT_STORED, ItemStorageNBT.getStoredFromNBT(tag));
        otherTag.func_74782_a(NBT_ITEMS, (NBTBase)new NBTTagList());
        otherTag.func_74768_a(NBT_PROTOCOL, 1);
        return otherTag;
    }

    public static NBTTagCompound createNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_ITEMS, (NBTBase)new NBTTagList());
        tag.func_74768_a(NBT_STORED, 0);
        tag.func_74768_a(NBT_PROTOCOL, 1);
        return tag;
    }

    public static boolean isValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_ITEMS) && stack.func_77978_p().func_74764_b(NBT_STORED);
    }

    public static ItemStack createStackWithNBT(ItemStack stack) {
        stack.func_77982_d(ItemStorageNBT.createNBT());
        return stack;
    }
}

