/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.item;

import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.network.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.IWirelessTransmitter;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class NetworkItemHandler
implements INetworkItemHandler {
    private INetworkMaster network;
    private List<INetworkItem> items = new ArrayList<INetworkItem>();
    private List<INetworkItem> itemsToRemove = new ArrayList<INetworkItem>();

    public NetworkItemHandler(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void update() {
        this.items.removeAll(this.itemsToRemove);
        this.itemsToRemove.clear();
    }

    @Override
    public boolean onOpen(EntityPlayer player, World controllerWorld, EnumHand hand) {
        boolean inRange = false;
        for (INetworkNode node : this.network.getNodeGraph().all()) {
            IWirelessTransmitter transmitter;
            double distance;
            if (!(node instanceof IWirelessTransmitter) || !node.canUpdate() || node.getNodeWorld().field_73011_w.getDimension() != player.field_71093_bK || !((distance = Math.sqrt(Math.pow((double)(transmitter = (IWirelessTransmitter)((Object)node)).getOrigin().func_177958_n() - player.field_70165_t, 2.0) + Math.pow((double)transmitter.getOrigin().func_177956_o() - player.field_70163_u, 2.0) + Math.pow((double)transmitter.getOrigin().func_177952_p() - player.field_70161_v, 2.0))) < (double)transmitter.getRange())) continue;
            inRange = true;
            break;
        }
        if (!inRange) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        INetworkItem item = ((INetworkItemProvider)stack.func_77973_b()).provide(this, player, stack);
        if (item.onOpen(this.network, player, controllerWorld, hand)) {
            this.items.add(item);
            return true;
        }
        return false;
    }

    @Override
    public void onClose(EntityPlayer player) {
        INetworkItem item = this.getItem(player);
        if (item != null) {
            this.itemsToRemove.add(item);
        }
    }

    @Override
    public INetworkItem getItem(EntityPlayer player) {
        for (INetworkItem item : this.items) {
            if (item.getPlayer() != player) continue;
            return item;
        }
        return null;
    }
}

