/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.network.grid.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidGridHandler
implements IFluidGridHandler {
    private INetworkMaster network;

    public FluidGridHandler(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void onExtract(int hash, boolean shift, EntityPlayerMP player) {
        FluidStack stack = this.network.getFluidStorageCache().getList().get(hash);
        if (stack == null || stack.amount < 1000) {
            return;
        }
        if (RSUtils.hasFluidBucket(stack)) {
            ItemStack bucket = null;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slot = player.field_71071_by.func_70301_a(i);
                if (!API.instance().getComparer().isEqualNoQuantity(RSUtils.EMPTY_BUCKET, slot)) continue;
                bucket = RSUtils.EMPTY_BUCKET.func_77946_l();
                player.field_71071_by.func_70298_a(i, 1);
                break;
            }
            if (bucket == null) {
                bucket = this.network.extractItem(RSUtils.EMPTY_BUCKET, 1, false);
            }
            if (bucket != null) {
                ((IFluidHandler)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(this.network.extractFluid(stack, 1000, false), true);
                if (shift) {
                    if (!player.field_71071_by.func_70441_a(bucket.func_77946_l())) {
                        InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)bucket);
                    }
                } else {
                    player.field_71071_by.func_70437_b(bucket);
                    player.func_71113_k();
                }
            }
        }
    }

    @Override
    @Nullable
    public ItemStack onInsert(ItemStack container) {
        FluidStack stack = RSUtils.getFluidFromStack(container, true);
        if (stack != null && this.network.insertFluid(stack, stack.amount, true) == null) {
            FluidStack drained = RSUtils.getFluidFromStack(container, false);
            this.network.insertFluid(drained, drained.amount, false);
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(EntityPlayerMP player) {
        this.onInsert(player.field_71071_by.func_70445_o());
        player.func_71113_k();
    }
}

