/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.util.IFluidStackList;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementInfo;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementItemRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementText;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementFluidStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementItemStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStepCraft;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStepProcess;
import com.raoulvdberge.refinedstorage.apiimpl.util.ItemStackList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingTask
implements ICraftingTask {
    protected static final int DEFAULT_COMPARE = 19;
    public static final String NBT_STEPS = "Steps";
    public static final String NBT_TO_TAKE_FLUIDS = "ToTakeFluids";
    public static final String NBT_TO_INSERT_ITEMS = "ToInsertItems";
    public static final String NBT_TO_INSERT_FLUIDS = "ToInsertFluids";
    private INetworkMaster network;
    @Nullable
    private ItemStack requested;
    private ICraftingPattern pattern;
    private int quantity;
    private List<ICraftingStep> mainSteps = new LinkedList<ICraftingStep>();
    private IItemStackList toTake = API.instance().createItemStackList();
    private IItemStackList toCraft = API.instance().createItemStackList();
    private IItemStackList missing = API.instance().createItemStackList();
    private Set<ICraftingPattern> usedPatterns = new HashSet<ICraftingPattern>();
    private boolean recurseFound = false;
    private Deque<ItemStack> toInsertItems = new ArrayDeque<ItemStack>();
    private Deque<FluidStack> toInsertFluids = new ArrayDeque<FluidStack>();
    private IFluidStackList toTakeFluids = API.instance().createFluidStackList();

    public CraftingTask(INetworkMaster network, @Nullable ItemStack requested, ICraftingPattern pattern, int quantity) {
        this.network = network;
        this.requested = requested;
        this.pattern = pattern;
        this.quantity = quantity;
    }

    public CraftingTask(INetworkMaster network, @Nullable ItemStack requested, ICraftingPattern pattern, int quantity, List<ICraftingStep> mainSteps, Deque<ItemStack> toInsertItems, IFluidStackList toTakeFluids, Deque<FluidStack> toInsertFluids) {
        this(network, requested, pattern, quantity);
        this.mainSteps = mainSteps;
        this.toInsertItems = toInsertItems;
        this.toTakeFluids = toTakeFluids;
        this.toInsertFluids = toInsertFluids;
    }

    @Override
    public void calculate() {
        IItemStackList networkList = this.network.getItemStorageCache().getList().copy();
        networkList.clean();
        networkList = networkList.getOredicted();
        IFluidStackList networkFluidList = this.network.getFluidStorageCache().getList().copy();
        IItemStackList toInsert = API.instance().createItemStackList();
        ItemStack requested = this.requested != null ? this.requested : this.pattern.getOutputs().get(0);
        this.toCraft.add(ItemHandlerHelper.copyStackWithSize((ItemStack)requested, (int)this.quantity));
        for (int quantity = this.quantity; quantity > 0 && !this.recurseFound; quantity -= this.pattern.getQuantityPerRequest(requested)) {
            this.mainSteps.add(this.calculate(networkList, networkFluidList, this.pattern, toInsert));
        }
        this.usedPatterns.clear();
    }

    private ICraftingStep calculate(IItemStackList networkList, IFluidStackList networkFluidList, ICraftingPattern pattern, IItemStackList toInsert) {
        List<ItemStack> outputs;
        this.recurseFound |= !this.usedPatterns.add(pattern);
        if (this.recurseFound) {
            return null;
        }
        int compare = 19;
        IItemStackList actualInputs = API.instance().createItemStackList();
        LinkedList<ItemStack> usedStacks = new LinkedList<ItemStack>();
        LinkedList<ICraftingStep> previousSteps = new LinkedList<ICraftingStep>();
        IItemStackList byproductList = API.instance().createItemStackList();
        pattern.getByproducts().stream().filter(Objects::nonNull).forEach(byproductList::add);
        for (List<ItemStack> inputs : pattern.getOreInputs()) {
            ItemStack input;
            ItemStack networkStack;
            ItemStack extraStack;
            if (inputs == null || inputs.isEmpty()) {
                usedStacks.add(null);
                continue;
            }
            int i = 0;
            do {
                compare = (input = inputs.get(i).func_77946_l()).func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
                extraStack = toInsert.get(input, compare);
                networkStack = networkList.get(input, compare);
            } while (extraStack == null && networkStack == null && ++i < inputs.size() && this.network.getPatterns(input, compare).isEmpty());
            if (i == inputs.size()) {
                input = inputs.get(0).func_77946_l();
            }
            usedStacks.add(input.func_77946_l());
            int lambdaCompare = compare | (pattern.isOredict() ? 8 : 0);
            ItemStack lambdaInput = input;
            ICraftingPattern inputPattern = null;
            int available = (extraStack == null ? 0 : extraStack.field_77994_a) + (networkStack == null ? 0 : networkStack.field_77994_a);
            if (available < input.field_77994_a && (inputPattern = this.network.getPattern(input, compare, networkList)) != null && inputPattern.getInputs().stream().anyMatch(s -> API.instance().getComparer().isEqual((ItemStack)s, lambdaInput, lambdaCompare))) {
                int craftQuantity = inputPattern.getQuantityPerRequest(input, compare);
                long needed = (long)((networkStack == null ? 0 : -networkStack.field_77994_a) + input.field_77994_a) + inputPattern.getInputs().stream().filter(s -> API.instance().getComparer().isEqual((ItemStack)s, lambdaInput, lambdaCompare)).count() * 2L;
                do {
                    previousSteps.add(this.calculate(networkList, networkFluidList, inputPattern, toInsert));
                    this.toCraft.add(ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)craftQuantity));
                } while ((extraStack = toInsert.get(input, compare)) != null && (long)extraStack.field_77994_a < needed);
            }
            while (input.field_77994_a > 0) {
                int takeQuantity;
                if (extraStack != null && extraStack.field_77994_a > 0) {
                    takeQuantity = Math.min(extraStack.field_77994_a, input.field_77994_a);
                    ItemStack inputStack = ItemHandlerHelper.copyStackWithSize((ItemStack)extraStack, (int)takeQuantity);
                    actualInputs.add(inputStack.func_77946_l());
                    input.field_77994_a -= takeQuantity;
                    if (byproductList.get(inputStack, compare) == null) {
                        this.toCraft.add(inputStack);
                    }
                    toInsert.remove(inputStack, true);
                    if (input.field_77994_a <= 0) continue;
                    i = 0;
                    while (((extraStack = toInsert.get(inputs.get(i), compare)) == null || extraStack.field_77994_a == 0) && ++i < inputs.size()) {
                    }
                    continue;
                }
                if (networkStack != null && networkStack.field_77994_a > 0) {
                    takeQuantity = Math.min(networkStack.field_77994_a, input.field_77994_a);
                    ItemStack inputStack = ItemHandlerHelper.copyStackWithSize((ItemStack)networkStack, (int)takeQuantity);
                    this.toTake.add(inputStack.func_77946_l());
                    actualInputs.add(inputStack.func_77946_l());
                    input.field_77994_a -= takeQuantity;
                    networkList.remove(inputStack, true);
                    if (input.field_77994_a <= 0) continue;
                    i = 0;
                    do {
                        networkStack = networkList.get(inputs.get(i), compare);
                    } while ((extraStack == null || extraStack.field_77994_a == 0) && ++i < inputs.size());
                    continue;
                }
                int oreDictedCompare = compare | (pattern.isOredict() ? 8 : 0);
                if (inputPattern == null) {
                    inputPattern = this.network.getPattern(input, oreDictedCompare, networkList);
                }
                if (inputPattern != null) {
                    ItemStack actualCraft = inputPattern.getActualOutput(input, oreDictedCompare);
                    int craftQuantity = Math.min(inputPattern.getQuantityPerRequest(input, oreDictedCompare), input.field_77994_a);
                    ItemStack inputCrafted = ItemHandlerHelper.copyStackWithSize((ItemStack)actualCraft, (int)craftQuantity);
                    this.toCraft.add(inputCrafted.func_77946_l());
                    actualInputs.add(inputCrafted.func_77946_l());
                    previousSteps.add(this.calculate(networkList, networkFluidList, inputPattern, toInsert));
                    input.field_77994_a -= craftQuantity;
                    if (this.recurseFound) continue;
                    ItemStack inserted = toInsert.get(inputCrafted, compare);
                    toInsert.remove(inserted, craftQuantity, true);
                    continue;
                }
                ItemStack fluidCheck = ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)1);
                while (input.field_77994_a > 0 && this.doFluidCalculation(networkList, networkFluidList, fluidCheck, toInsert, previousSteps)) {
                    actualInputs.add(fluidCheck);
                    --input.field_77994_a;
                }
                if (input.field_77994_a <= 0) continue;
                ItemStack copy = input.func_77946_l();
                if (copy.func_77952_i() == Short.MAX_VALUE) {
                    copy.func_77964_b(0);
                }
                this.missing.add(copy);
                input.field_77994_a = 0;
            }
        }
        ItemStack[] took = null;
        if (this.missing.isEmpty() && !pattern.isProcessing()) {
            took = ItemStackList.toCraftingGrid(actualInputs, usedStacks, compare | (pattern.isOredict() ? 8 : 0));
        }
        List<ItemStack> list = outputs = !pattern.isProcessing() && pattern.isOredict() && this.missing.isEmpty() ? pattern.getOutputs(took) : pattern.getOutputs();
        if (outputs == null) {
            outputs = pattern.getOutputs();
        }
        for (ItemStack output : outputs) {
            toInsert.add(output.func_77946_l());
        }
        for (ItemStack byproduct : !pattern.isProcessing() && pattern.isOredict() && this.missing.isEmpty() ? pattern.getByproducts(took) : pattern.getByproducts()) {
            toInsert.add(byproduct.func_77946_l());
        }
        this.usedPatterns.remove(pattern);
        return pattern.isProcessing() ? new CraftingStepProcess(this.network, pattern, previousSteps) : new CraftingStepCraft(this.network, pattern, usedStacks, previousSteps);
    }

    private boolean doFluidCalculation(IItemStackList networkList, IFluidStackList networkFluidList, ItemStack input, IItemStackList toInsert, List<ICraftingStep> previousSteps) {
        FluidStack fluidInItem = RSUtils.getFluidFromStack(input, true);
        if (fluidInItem != null && RSUtils.hasFluidBucket(fluidInItem)) {
            FluidStack fluidInStorage = networkFluidList.get(fluidInItem);
            if (fluidInStorage == null || fluidInStorage.amount < fluidInItem.amount) {
                this.missing.add(input);
            } else {
                ItemStack bucket = toInsert.get(RSUtils.EMPTY_BUCKET);
                boolean hasBucket = false;
                if (bucket != null && bucket.field_77994_a > 0) {
                    hasBucket = toInsert.remove(RSUtils.EMPTY_BUCKET, 1, false);
                }
                if (!hasBucket && (bucket = networkList.get(RSUtils.EMPTY_BUCKET)) != null && bucket.field_77994_a > 0) {
                    hasBucket = networkList.remove(RSUtils.EMPTY_BUCKET, 1, false);
                }
                ICraftingPattern bucketPattern = this.network.getPattern(RSUtils.EMPTY_BUCKET);
                if (!hasBucket) {
                    if (bucketPattern == null) {
                        this.missing.add(RSUtils.EMPTY_BUCKET.func_77946_l());
                    } else {
                        this.toCraft.add(RSUtils.EMPTY_BUCKET.func_77946_l());
                        previousSteps.add(this.calculate(networkList, networkFluidList, bucketPattern, toInsert));
                        toInsert.remove(RSUtils.EMPTY_BUCKET, 1, false);
                    }
                }
                if (hasBucket || bucketPattern != null) {
                    this.toTakeFluids.add(fluidInItem.copy());
                    networkFluidList.remove(fluidInItem, false);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onCancelled() {
        for (ItemStack stack : this.toInsertItems) {
            this.network.insertItem(stack, stack.field_77994_a, false);
        }
        this.network.markCraftingMonitorForUpdate();
    }

    public String toString() {
        return "\nCraftingTask{quantity=" + this.quantity + "\n, toTake=" + this.toTake + "\n, toTakeFluids=" + this.toTakeFluids + "\n, toCraft=" + this.toCraft + "\n, toInsertItems=" + this.toInsertItems + "\n, toInsertFluids=" + this.toInsertFluids + "\n, mainSteps=" + this.mainSteps + '}';
    }

    @Override
    public boolean update(Map<ICraftingPatternContainer, Integer> usedContainers) {
        Object step;
        IItemStackList oreDictPrepped = this.network.getItemStorageCache().getList().getOredicted();
        IFluidStackList networkFluids = this.network.getFluidStorageCache().getList();
        if (!this.missing.isEmpty()) {
            for (ItemStack missing : this.missing.getStacks()) {
                if (oreDictPrepped.trackedRemove(missing, true)) continue;
                oreDictPrepped.undo();
                return false;
            }
            oreDictPrepped.undo();
            this.reschedule();
            return false;
        }
        int times = this.toInsertItems.size();
        for (int i = 0; i < times; ++i) {
            ItemStack remainder;
            ItemStack insert = this.toInsertItems.poll();
            if (insert == null || (remainder = this.network.insertItem(insert, insert.field_77994_a, false)) == null) continue;
            this.toInsertItems.add(remainder);
        }
        LinkedList<Object> leafSteps = new LinkedList<Object>();
        LinkedList<ICraftingStep> steps = new LinkedList<ICraftingStep>();
        steps.addAll(this.mainSteps);
        while (steps.size() > 0) {
            step = (ICraftingStep)steps.poll();
            if (step.getPreliminarySteps().size() > 0) {
                steps.addAll(step.getPreliminarySteps());
                continue;
            }
            leafSteps.add(step);
        }
        for (ICraftingStep iCraftingStep : leafSteps) {
            if (iCraftingStep.hasStartedProcessing()) continue;
            ICraftingPatternContainer container = iCraftingStep.getPattern().getContainer();
            Integer timesUsed = usedContainers.get(container);
            if (timesUsed == null) {
                timesUsed = 0;
            }
            Integer n = timesUsed;
            Integer n2 = timesUsed = Integer.valueOf(timesUsed + 1);
            if (n > container.getSpeedUpdateCount() || !iCraftingStep.canStartProcessing(oreDictPrepped, networkFluids)) continue;
            iCraftingStep.setStartedProcessing();
            iCraftingStep.execute(this.toInsertItems, this.toInsertFluids);
            usedContainers.put(container, timesUsed);
            this.network.markCraftingMonitorForUpdate();
        }
        if (this.getSteps().stream().filter(ICraftingStep::hasStartedProcessing).count() == 0L) {
            this.reschedule();
        }
        steps.clear();
        this.mainSteps.removeIf(ICraftingStep::hasReceivedOutputs);
        steps.addAll(this.mainSteps);
        while (steps.size() > 0) {
            step = (ICraftingStep)steps.poll();
            step.getPreliminarySteps().removeIf(ICraftingStep::hasReceivedOutputs);
            steps.addAll(step.getPreliminarySteps());
        }
        return this.isFinished();
    }

    @Override
    public void reschedule() {
        List mainSteps = this.getSteps().stream().filter(s -> s.getPattern() == this.pattern).collect(Collectors.toList());
        this.missing.clear();
        this.mainSteps.clear();
        if (!mainSteps.isEmpty()) {
            this.quantity = 0;
            int quantityPerRequest = this.pattern.getQuantityPerRequest(this.requested);
            for (ICraftingStep step : mainSteps) {
                this.quantity += quantityPerRequest - step.getReceivedOutput(this.requested);
            }
            if (this.quantity > 0) {
                this.calculate();
            }
            this.network.markCraftingMonitorForUpdate();
        }
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    @Nullable
    public ItemStack getRequested() {
        return this.requested;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        this.writeDefaultsToNBT(tag);
        NBTTagList stepsList = new NBTTagList();
        for (ICraftingStep iCraftingStep : this.mainSteps) {
            stepsList.func_74742_a((NBTBase)iCraftingStep.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_STEPS, (NBTBase)stepsList);
        NBTTagList toInsertItemsList = new NBTTagList();
        for (ItemStack insert : this.toInsertItems) {
            toInsertItemsList.func_74742_a((NBTBase)insert.serializeNBT());
        }
        tag.func_74782_a(NBT_TO_INSERT_ITEMS, (NBTBase)toInsertItemsList);
        tag.func_74782_a(NBT_TO_TAKE_FLUIDS, (NBTBase)RSUtils.serializeFluidStackList(this.toTakeFluids));
        NBTTagList nBTTagList = new NBTTagList();
        for (FluidStack insert : this.toInsertFluids) {
            nBTTagList.func_74742_a((NBTBase)insert.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_TO_INSERT_FLUIDS, (NBTBase)nBTTagList);
        return tag;
    }

    @Override
    public List<ICraftingMonitorElement> getCraftingMonitorElements() {
        ICraftingMonitorElementList elements = API.instance().createCraftingMonitorElementList();
        elements.directAdd(new CraftingMonitorElementItemRender(this.network.getCraftingTasks().indexOf(this), this.requested != null ? this.requested : this.pattern.getOutputs().get(0), this.quantity, 0));
        if (!this.missing.isEmpty()) {
            elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_missing", 16));
            this.missing.getStacks().stream().map(stack -> new CraftingMonitorElementError(new CraftingMonitorElementItemRender(-1, (ItemStack)stack, stack.field_77994_a, 32), "")).forEach(elements::add);
            elements.commit();
        }
        if (!this.toInsertItems.isEmpty()) {
            elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_inserting", 16));
            this.toInsertItems.stream().map(stack -> new CraftingMonitorElementItemRender(-1, (ItemStack)stack, stack.field_77994_a, 32)).forEach(elements::add);
            elements.commit();
        }
        if (!this.isFinished()) {
            if (this.getSteps().stream().filter(s -> !s.getPattern().isProcessing()).count() > 0L) {
                elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_crafting", 16));
                IItemStackList oreDictPrepped = this.network.getItemStorageCache().getList().getOredicted();
                IFluidStackList networkFluids = this.network.getFluidStorageCache().getList();
                for (ICraftingStep step : this.getSteps().stream().filter(s -> !s.getPattern().isProcessing()).collect(Collectors.toList())) {
                    for (int i = 0; i < step.getPattern().getOutputs().size(); ++i) {
                        ICraftingMonitorElement element = new CraftingMonitorElementItemRender(-1, step.getPattern().getOutputs().get(i), step.getPattern().getOutputs().get((int)i).field_77994_a, 32);
                        if (!step.hasStartedProcessing() && !step.canStartProcessing(oreDictPrepped, networkFluids)) {
                            element = new CraftingMonitorElementInfo(element, "gui.refinedstorage:crafting_monitor.waiting_for_items");
                        }
                        elements.add(element);
                    }
                }
                elements.commit();
            }
            if (this.getSteps().stream().filter(s -> s.getPattern().isProcessing()).count() > 0L) {
                elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_processing", 16));
                for (ICraftingStep step : this.getSteps().stream().filter(s -> s.getPattern().isProcessing()).collect(Collectors.toList())) {
                    for (int i = 0; i < step.getPattern().getOutputs().size(); ++i) {
                        ICraftingMonitorElement element = new CraftingMonitorElementItemRender(-1, step.getPattern().getOutputs().get(i), step.getPattern().getOutputs().get((int)i).field_77994_a, 32);
                        if (step.getPattern().getContainer().getFacingTile() == null) {
                            element = new CraftingMonitorElementError(element, "gui.refinedstorage:crafting_monitor.machine_none");
                        } else if (!step.hasStartedProcessing() && !step.canStartProcessing()) {
                            element = new CraftingMonitorElementError(element, "gui.refinedstorage:crafting_monitor.machine_in_use");
                        }
                        elements.add(element);
                    }
                }
                elements.commit();
            }
        }
        return elements.getElements();
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public List<ICraftingStep> getSteps() {
        LinkedList<ICraftingStep> allSteps = new LinkedList<ICraftingStep>();
        LinkedList<ICraftingStep> steps = new LinkedList<ICraftingStep>();
        steps.addAll(this.mainSteps);
        while (steps.size() > 0) {
            ICraftingStep step = (ICraftingStep)steps.poll();
            allSteps.add(step);
            steps.addAll(step.getPreliminarySteps());
        }
        return allSteps;
    }

    @Override
    public boolean isValid() {
        return !this.recurseFound;
    }

    @Override
    public IItemStackList getMissing() {
        return this.missing;
    }

    @Override
    public List<ICraftingPreviewElement> getPreviewStacks() {
        CraftingPreviewElementItemStack previewStack;
        int hash;
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        LinkedHashMap<Integer, CraftingPreviewElementItemStack> map = new LinkedHashMap<Integer, CraftingPreviewElementItemStack>();
        for (ItemStack stack : this.toCraft.getStacks()) {
            hash = API.instance().getItemStackHashCode(stack);
            previewStack = (CraftingPreviewElementItemStack)map.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementItemStack(stack);
            }
            previewStack.addToCraft(stack.field_77994_a);
            map.put(hash, previewStack);
        }
        for (ItemStack stack : this.missing.getStacks()) {
            hash = API.instance().getItemStackHashCode(stack);
            previewStack = (CraftingPreviewElementItemStack)map.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementItemStack(stack);
            }
            previewStack.setMissing(true);
            previewStack.addToCraft(stack.field_77994_a);
            map.put(hash, previewStack);
        }
        for (ItemStack stack : this.toTake.getStacks()) {
            hash = API.instance().getItemStackHashCode(stack);
            previewStack = (CraftingPreviewElementItemStack)map.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementItemStack(stack);
            }
            previewStack.addAvailable(stack.field_77994_a);
            map.put(hash, previewStack);
        }
        ArrayList<ICraftingPreviewElement> elements = new ArrayList<ICraftingPreviewElement>(map.values());
        this.toTakeFluids.getStacks().stream().map(CraftingPreviewElementFluidStack::new).forEach(elements::add);
        return elements;
    }

    private boolean isFinished() {
        return this.mainSteps.stream().allMatch(ICraftingStep::hasReceivedOutputs);
    }
}

