/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview;

import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingPreviewElementItemStack
implements ICraftingPreviewElement<ItemStack> {
    public static final String ID = "item_renderer";
    private ItemStack stack;
    private int available;
    private boolean missing;
    private int toCraft;

    public CraftingPreviewElementItemStack(ItemStack stack) {
        this.stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
    }

    public CraftingPreviewElementItemStack(ItemStack stack, int available, boolean missing, int toCraft) {
        this.stack = stack;
        this.available = available;
        this.missing = missing;
        this.toCraft = toCraft;
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        buf.writeInt(Item.func_150891_b((Item)this.stack.func_77973_b()));
        buf.writeInt(this.stack.func_77960_j());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stack.func_77978_p());
        buf.writeInt(this.available);
        buf.writeBoolean(this.missing);
        buf.writeInt(this.toCraft);
    }

    public static CraftingPreviewElementItemStack fromByteBuf(ByteBuf buf) {
        Item item = Item.func_150899_d((int)buf.readInt());
        int meta = buf.readInt();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        int available = buf.readInt();
        boolean missing = buf.readBoolean();
        int toCraft = buf.readInt();
        ItemStack stack = new ItemStack(item, 1, meta);
        stack.func_77982_d(tag);
        return new CraftingPreviewElementItemStack(stack, available, missing, toCraft);
    }

    @Override
    public ItemStack getElement() {
        return this.stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers) {
        if (this.missing) {
            drawers.getOverlayDrawer().draw(x, y, -860450);
        }
        drawers.getItemDrawer().draw(x += 5, y += 7, this.getElement());
        float scale = 0.5f;
        y += 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        if (this.getToCraft() > 0) {
            String format = this.hasMissing() ? "gui.refinedstorage:crafting_preview.missing" : "gui.refinedstorage:crafting_preview.to_craft";
            drawers.getStringDrawer().draw(GuiBase.calculateOffsetOnScale(x + 23, scale), GuiBase.calculateOffsetOnScale(y, scale), GuiBase.t(format, this.getToCraft()));
            y += 7;
        }
        if (this.getAvailable() > 0) {
            drawers.getStringDrawer().draw(GuiBase.calculateOffsetOnScale(x + 23, scale), GuiBase.calculateOffsetOnScale(y, scale), GuiBase.t("gui.refinedstorage:crafting_preview.available", this.getAvailable()));
        }
        GlStateManager.func_179121_F();
    }

    public void addAvailable(int amount) {
        this.available += amount;
    }

    @Override
    public int getAvailable() {
        return this.available;
    }

    public void addToCraft(int amount) {
        this.toCraft += amount;
    }

    @Override
    public int getToCraft() {
        return this.toCraft;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    @Override
    public boolean hasMissing() {
        return this.missing;
    }

    @Override
    public String getId() {
        return ID;
    }
}

