/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingMonitorElementText
implements ICraftingMonitorElement {
    public static final String ID = "text";
    private String text;
    private int offset;

    public CraftingMonitorElementText(String text, int offset) {
        this.text = text;
        this.offset = offset;
    }

    public String getText() {
        return this.text;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers) {
        float scale = 0.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        drawers.getStringDrawer().draw(GuiBase.calculateOffsetOnScale(x + this.offset, scale), GuiBase.calculateOffsetOnScale(y + 7, scale), I18n.func_135052_a((String)this.text, (Object[])new Object[0]));
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean canDrawSelection() {
        return true;
    }

    @Override
    public int getTaskId() {
        return -1;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
        buf.writeInt(this.offset);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        return element.getId().equals(this.getId()) && this.elementHashCode() == element.elementHashCode();
    }

    @Override
    public int elementHashCode() {
        return this.text.hashCode();
    }
}

