/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingMonitorElementItemRender
implements ICraftingMonitorElement {
    public static final String ID = "item_render";
    private int taskId;
    private ItemStack stack;
    private int quantity;
    private int offset;

    public CraftingMonitorElementItemRender(int taskId, ItemStack stack, int quantity, int offset) {
        this.taskId = taskId;
        this.stack = stack;
        this.quantity = quantity;
        this.offset = offset;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers) {
        drawers.getItemDrawer().draw(x + 2 + this.offset, y + 1, this.stack);
        float scale = 0.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        drawers.getStringDrawer().draw(GuiBase.calculateOffsetOnScale(x + 21 + this.offset, scale), GuiBase.calculateOffsetOnScale(y + 7, scale), this.quantity + "x " + this.stack.func_82833_r());
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean canDrawSelection() {
        return true;
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.taskId);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeInt(this.quantity);
        buf.writeInt(this.offset);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        if (element.getId().equals(this.getId()) && this.elementHashCode() == element.elementHashCode()) {
            this.quantity += ((CraftingMonitorElementItemRender)element).quantity;
            return true;
        }
        return false;
    }

    @Override
    public int elementHashCode() {
        return API.instance().getItemStackHashCode(this.stack);
    }
}

