/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingMonitorElementFluidRender
implements ICraftingMonitorElement {
    public static final String ID = "fluid_render";
    private int taskId;
    private FluidStack stack;
    private int offset;

    public CraftingMonitorElementFluidRender(int taskId, FluidStack stack, int offset) {
        this.taskId = taskId;
        this.stack = stack;
        this.offset = offset;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers) {
        drawers.getFluidDrawer().draw(x + 2 + this.offset, y + 1, this.stack);
        float scale = 0.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        drawers.getStringDrawer().draw(GuiBase.calculateOffsetOnScale(x + 21 + this.offset, scale), GuiBase.calculateOffsetOnScale(y + 7, scale), RSUtils.QUANTITY_FORMATTER.format((float)this.stack.amount / 1000.0f) + "x " + this.stack.getLocalizedName());
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean canDrawSelection() {
        return true;
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.taskId);
        RSUtils.writeFluidStack(buf, this.stack);
        buf.writeInt(this.offset);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        if (element.getId().equals(this.getId()) && this.elementHashCode() == element.elementHashCode()) {
            this.stack.amount += ((CraftingMonitorElementFluidRender)element).stack.amount;
            return true;
        }
        return false;
    }

    @Override
    public int elementHashCode() {
        return API.instance().getFluidStackHashCode(this.stack);
    }
}

