/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.util.Comparer;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CraftingPattern
implements ICraftingPattern {
    private ICraftingPatternContainer container;
    private ItemStack stack;
    private IRecipe recipe;
    private List<ItemStack> inputs = new ArrayList<ItemStack>();
    private List<List<ItemStack>> oreInputs = new ArrayList<List<ItemStack>>();
    private List<ItemStack> outputs = new ArrayList<ItemStack>();
    private List<ItemStack> byproducts = new ArrayList<ItemStack>();
    private boolean mekanism = false;

    public CraftingPattern(World world, ICraftingPatternContainer container, ItemStack stack) {
        this.container = container;
        this.stack = Comparer.stripTags(stack);
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            ItemStack slot = ItemPattern.getSlot(stack, i);
            this.inputs.add(slot);
            inv.func_70299_a(i, slot);
        }
        if (!ItemPattern.isProcessing(stack)) {
            ItemStack output;
            this.recipe = CraftingManager.func_77594_a().func_77592_b().stream().filter(r -> r.func_77569_a(inv, world)).findFirst().orElse(null);
            if (this.recipe != null && (output = this.recipe.func_77572_b(inv)) != null) {
                boolean shapedOre = this.recipe instanceof ShapedOreRecipe;
                this.mekanism = this.recipe.getClass().getName().equals("mekanism.common.recipe.ShapedMekanismRecipe");
                this.outputs.add(Comparer.stripTags(output.func_77946_l()));
                if (this.isOredict() && shapedOre || this.mekanism) {
                    Object[] inputs = new Object[]{};
                    if (shapedOre) {
                        inputs = ((ShapedOreRecipe)this.recipe).getInput();
                    } else {
                        try {
                            inputs = (Object[])this.recipe.getClass().getMethod("getInput", new Class[0]).invoke((Object)this.recipe, new Object[0]);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    Object[] e = inputs;
                    int n = e.length;
                    for (int i = 0; i < n; ++i) {
                        Object input = e[i];
                        if (input == null) {
                            this.oreInputs.add(Collections.emptyList());
                            continue;
                        }
                        if (input instanceof ItemStack) {
                            this.oreInputs.add(Collections.singletonList(Comparer.stripTags(((ItemStack)input).func_77946_l())));
                            continue;
                        }
                        LinkedList<ItemStack> cleaned = new LinkedList<ItemStack>();
                        for (ItemStack in : (List)input) {
                            cleaned.add(Comparer.stripTags(in.func_77946_l()));
                        }
                        this.oreInputs.add(cleaned);
                    }
                }
                for (ItemStack remaining : this.recipe.func_179532_b(inv)) {
                    if (remaining == null) continue;
                    this.byproducts.add(Comparer.stripTags(remaining.func_77946_l()));
                }
            }
        } else {
            this.outputs = ItemPattern.getOutputs(stack).stream().collect(Collectors.toList());
        }
        if (this.oreInputs.isEmpty()) {
            for (ItemStack input : this.inputs) {
                if (input == null) {
                    this.oreInputs.add(Collections.emptyList());
                    continue;
                }
                if (this.isOredict()) {
                    int[] ids = OreDictionary.getOreIDs((ItemStack)input);
                    if (ids == null || ids.length == 0) {
                        this.oreInputs.add(Collections.singletonList(Comparer.stripTags(input)));
                        continue;
                    }
                    List oredict = Arrays.stream(ids).mapToObj(OreDictionary::getOreName).map(OreDictionary::getOres).flatMap(Collection::stream).map(ItemStack::func_77946_l).map(Comparer::stripTags).map(s -> {
                        s.field_77994_a = input.field_77994_a;
                        return s;
                    }).collect(Collectors.toList());
                    oredict.add(0, Comparer.stripTags(input.func_77946_l()));
                    this.oreInputs.add(oredict);
                    continue;
                }
                this.oreInputs.add(Collections.singletonList(Comparer.stripTags(input)));
            }
        }
    }

    @Override
    public ICraftingPatternContainer getContainer() {
        return this.container;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isValid() {
        return this.inputs.stream().filter(Objects::nonNull).count() > 0L && !this.outputs.isEmpty();
    }

    @Override
    public boolean isProcessing() {
        return ItemPattern.isProcessing(this.stack);
    }

    @Override
    public boolean isOredict() {
        return ItemPattern.isOredict(this.stack);
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    public List<List<ItemStack>> getOreInputs() {
        return this.oreInputs;
    }

    @Override
    @Nullable
    public List<ItemStack> getOutputs(ItemStack[] took) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, took[i]);
        }
        ItemStack cleaned = this.recipe.func_77572_b(inv);
        if (cleaned == null) {
            return null;
        }
        outputs.add(cleaned.func_77946_l());
        return outputs;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<ItemStack> getByproducts(ItemStack[] took) {
        ArrayList<ItemStack> byproducts = new ArrayList<ItemStack>();
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, took[i]);
        }
        for (ItemStack remaining : this.recipe.func_179532_b(inv)) {
            if (remaining == null) continue;
            byproducts.add(remaining.func_77946_l());
        }
        return byproducts;
    }

    @Override
    public List<ItemStack> getByproducts() {
        return this.byproducts;
    }

    @Override
    public String getId() {
        return "normal";
    }

    @Override
    public int getQuantityPerRequest(ItemStack requested, int compare) {
        int quantity = 0;
        requested = Comparer.stripTags(requested.func_77946_l());
        for (ItemStack output : this.outputs) {
            if (!API.instance().getComparer().isEqual(requested, output, compare)) continue;
            quantity += output.field_77994_a;
            if (ItemPattern.isProcessing(this.stack)) continue;
            break;
        }
        return quantity;
    }

    @Override
    public ItemStack getActualOutput(ItemStack requested, int compare) {
        requested = Comparer.stripTags(requested.func_77946_l());
        for (ItemStack output : this.outputs) {
            if (!API.instance().getComparer().isEqual(requested, output, compare)) continue;
            return output.func_77946_l();
        }
        return null;
    }

    public String toString() {
        return "CraftingPattern{container=" + this.container + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", byproducts=" + this.byproducts + '}';
    }
}

