/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public interface ICraftingTask {
    public static final String NBT_QUANTITY = "Quantity";
    public static final String NBT_PATTERN_ID = "PatternID";
    public static final String NBT_PATTERN_STACK = "PatternStack";
    public static final String NBT_PATTERN_CONTAINER = "PatternContainer";
    public static final String NBT_REQUESTED = "Requested";

    public void calculate();

    public void onCancelled();

    public boolean update(Map<ICraftingPatternContainer, Integer> var1);

    public void reschedule();

    public int getQuantity();

    @Nullable
    public ItemStack getRequested();

    public NBTTagCompound writeToNBT(NBTTagCompound var1);

    default public NBTTagCompound writeDefaultsToNBT(NBTTagCompound tag) {
        tag.func_74768_a(NBT_QUANTITY, this.getQuantity());
        tag.func_74778_a(NBT_PATTERN_ID, this.getPattern().getId());
        tag.func_74782_a(NBT_PATTERN_STACK, (NBTBase)this.getPattern().getStack().serializeNBT());
        tag.func_74772_a(NBT_PATTERN_CONTAINER, this.getPattern().getContainer().getPosition().func_177986_g());
        if (this.getRequested() != null) {
            tag.func_74782_a(NBT_REQUESTED, (NBTBase)this.getRequested().serializeNBT());
        }
        return tag;
    }

    public List<ICraftingMonitorElement> getCraftingMonitorElements();

    public ICraftingPattern getPattern();

    public List<ICraftingStep> getSteps();

    public boolean isValid();

    public IItemStackList getMissing();

    public List<ICraftingPreviewElement> getPreviewStacks();
}

