/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class RSConfig {
    private Configuration config;
    public int controllerBaseUsage;
    public int cableUsage;
    public int constructorUsage;
    public int crafterUsage;
    public int crafterPerPatternUsage;
    public int craftingMonitorUsage;
    public int destructorUsage;
    public int detectorUsage;
    public int diskDriveUsage;
    public int diskDrivePerDiskUsage;
    public int externalStorageUsage;
    public int externalStoragePerStorageUsage;
    public int exporterUsage;
    public int importerUsage;
    public int interfaceUsage;
    public int fluidInterfaceUsage;
    public int relayUsage;
    public int soldererUsage;
    public int storageUsage;
    public int fluidStorageUsage;
    public int wirelessTransmitterUsage;
    public int gridUsage;
    public int craftingGridUsage;
    public int patternGridUsage;
    public int fluidGridUsage;
    public int networkTransmitterUsage;
    public float networkTransmitterPerBlockUsage;
    public int networkReceiverUsage;
    public int diskManipulatorUsage;
    public int readerUsage;
    public int writerUsage;
    public int euConversion;
    public int controllerCapacity;
    public boolean controllerUsesEnergy;
    public int maxRows;
    public boolean largeFont;
    public int wirelessTransmitterBaseRange;
    public int wirelessTransmitterRangePerUpgrade;
    public boolean wirelessGridUsesEnergy;
    public int wirelessGridOpenUsage;
    public int wirelessGridExtractUsage;
    public int wirelessGridInsertUsage;
    public boolean wirelessCraftingMonitorUsesEnergy;
    public int wirelessCraftingMonitorOpenUsage;
    public int wirelessCraftingMonitorCancelUsage;
    public int wirelessCraftingMonitorCancelAllUsage;
    public int rangeUpgradeUsage;
    public int speedUpgradeUsage;
    public int craftingUpgradeUsage;
    public int stackUpgradeUsage;
    public int interdimensionalUpgradeUsage;
    public int silkTouchUpgradeUsage;
    public int fortuneUpgradeUsagePerFortune;
    private static final String ENERGY = "energy";
    private static final String CONTROLLER = "controller";
    private static final String GRID = "grid";
    private static final String WIRELESS_TRANSMITTER = "wirelessTransmitter";
    private static final String WIRELESS_GRID = "wirelessGrid";
    private static final String WIRELESS_CRAFTING_MONITOR = "wirelessCraftingMonitor";
    private static final String UPGRADES = "upgrades";

    public RSConfig(File configFile) {
        this.config = new Configuration(configFile);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
    }

    public Configuration getConfig() {
        return this.config;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("refinedstorage")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.controllerBaseUsage = this.config.getInt("controllerBase", ENERGY, 0, 0, Integer.MAX_VALUE, "The base energy used by the Controller");
        this.cableUsage = this.config.getInt("cable", ENERGY, 0, 0, Integer.MAX_VALUE, "The energy used by Cables");
        this.constructorUsage = this.config.getInt("constructor", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Constructors");
        this.crafterUsage = this.config.getInt("crafter", ENERGY, 2, 0, Integer.MAX_VALUE, "The base energy used by Crafters");
        this.crafterPerPatternUsage = this.config.getInt("crafterPerPattern", ENERGY, 1, 0, Integer.MAX_VALUE, "The additional energy used per Pattern in a Crafter");
        this.craftingMonitorUsage = this.config.getInt("craftingMonitor", ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Crafting Monitors");
        this.destructorUsage = this.config.getInt("destructor", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Destructors");
        this.detectorUsage = this.config.getInt("detector", ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Detectors");
        this.diskDriveUsage = this.config.getInt("diskDrive", ENERGY, 0, 0, Integer.MAX_VALUE, "The base energy used by Disk Drives");
        this.diskDrivePerDiskUsage = this.config.getInt("diskDrivePerDisk", ENERGY, 1, 0, Integer.MAX_VALUE, "The additional energy used by Storage Disks in Disk Drives");
        this.externalStorageUsage = this.config.getInt("externalStorage", ENERGY, 0, 0, Integer.MAX_VALUE, "The base energy used by External Storages");
        this.externalStoragePerStorageUsage = this.config.getInt("externalStoragePerStorage", ENERGY, 1, 0, Integer.MAX_VALUE, "The additional energy used per connected storage to an External Storage");
        this.exporterUsage = this.config.getInt("exporter", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Exporters");
        this.importerUsage = this.config.getInt("importer", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Importers");
        this.interfaceUsage = this.config.getInt("interface", ENERGY, 3, 0, Integer.MAX_VALUE, "The energy used by Interfaces");
        this.fluidInterfaceUsage = this.config.getInt("fluidInterface", ENERGY, 3, 0, Integer.MAX_VALUE, "The energy used by Fluid Interfaces");
        this.relayUsage = this.config.getInt("relay", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Relays");
        this.soldererUsage = this.config.getInt("solderer", ENERGY, 3, 0, Integer.MAX_VALUE, "The energy used by Solderers");
        this.storageUsage = this.config.getInt("storage", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Storage Blocks");
        this.fluidStorageUsage = this.config.getInt("fluidStorage", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Fluid Storage Blocks");
        this.wirelessTransmitterUsage = this.config.getInt(WIRELESS_TRANSMITTER, ENERGY, 8, 0, Integer.MAX_VALUE, "The energy used by Wireless Transmitters");
        this.gridUsage = this.config.getInt(GRID, ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Grids");
        this.craftingGridUsage = this.config.getInt("craftingGrid", ENERGY, 4, 0, Integer.MAX_VALUE, "The energy used by Crafting Grids");
        this.patternGridUsage = this.config.getInt("patternGrid", ENERGY, 3, 0, Integer.MAX_VALUE, "The energy used by Pattern Grids");
        this.fluidGridUsage = this.config.getInt("fluidGrid", ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Fluid Grids");
        this.networkTransmitterUsage = this.config.getInt("networkTransmitter", ENERGY, 50, 0, Integer.MAX_VALUE, "The base energy used by Network Transmitters");
        this.networkTransmitterPerBlockUsage = this.config.getFloat("networkTransmitterPerBlock", ENERGY, 4.0f, 0.0f, Float.MAX_VALUE, "The additional energy per block that the Network Transmitter uses, gets rounded up");
        this.networkReceiverUsage = this.config.getInt("networkReceiver", ENERGY, 15, 0, Integer.MAX_VALUE, "The energy used by Network Receivers");
        this.diskManipulatorUsage = this.config.getInt("diskManipulator", ENERGY, 3, 0, Integer.MAX_VALUE, "The energy used by Disk Manipulators");
        this.readerUsage = this.config.getInt("reader", ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Readers");
        this.writerUsage = this.config.getInt("writer", ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Writers");
        this.euConversion = this.config.getInt("euConversion", ENERGY, 8, 1, Integer.MAX_VALUE, "The amount of RS that equals 1 EU");
        this.controllerCapacity = this.config.getInt("capacity", CONTROLLER, 32000, 0, Integer.MAX_VALUE, "The energy capacity of the Controller");
        this.controllerUsesEnergy = this.config.getBoolean("usesEnergy", CONTROLLER, true, "Whether the Controller uses energy");
        this.maxRows = this.config.getInt("maxRows", GRID, Integer.MAX_VALUE, 3, Integer.MAX_VALUE, "The maximum amount of rows that the Grid can show");
        this.largeFont = this.config.getBoolean("largeFont", GRID, false, "Whether the controller should use a large font for stack quantity display");
        this.wirelessTransmitterBaseRange = this.config.getInt("range", WIRELESS_TRANSMITTER, 16, 0, Integer.MAX_VALUE, "The base range of the Wireless Transmitter");
        this.wirelessTransmitterRangePerUpgrade = this.config.getInt("rangePerUpgrade", WIRELESS_TRANSMITTER, 8, 0, Integer.MAX_VALUE, "The additional range per Range Upgrade in the Wireless Transmitter");
        this.wirelessGridUsesEnergy = this.config.getBoolean("usesEnergy", WIRELESS_GRID, true, "Whether the Wireless Grid uses energy");
        this.wirelessGridOpenUsage = this.config.getInt("open", WIRELESS_GRID, 30, 0, Integer.MAX_VALUE, "The energy used by the Wireless Grid to open");
        this.wirelessGridInsertUsage = this.config.getInt("insert", WIRELESS_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Wireless Grid to insert items");
        this.wirelessGridExtractUsage = this.config.getInt("extract", WIRELESS_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Wireless Grid to extract items");
        this.wirelessCraftingMonitorUsesEnergy = this.config.getBoolean("usesEnergy", WIRELESS_CRAFTING_MONITOR, true, "Whether the Wireless Crafting Monitor uses energy");
        this.wirelessCraftingMonitorOpenUsage = this.config.getInt("open", WIRELESS_CRAFTING_MONITOR, 35, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Monitor to open");
        this.wirelessCraftingMonitorCancelUsage = this.config.getInt("cancel", WIRELESS_CRAFTING_MONITOR, 4, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Monitor to cancel a task");
        this.wirelessCraftingMonitorCancelAllUsage = this.config.getInt("cancelAll", WIRELESS_CRAFTING_MONITOR, 5, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Monitor to cancel all tasks");
        this.rangeUpgradeUsage = this.config.getInt("range", UPGRADES, 8, 0, Integer.MAX_VALUE, "The additional energy used per Range Upgrade");
        this.speedUpgradeUsage = this.config.getInt("speed", UPGRADES, 2, 0, Integer.MAX_VALUE, "The additional energy used per Speed Upgrade");
        this.craftingUpgradeUsage = this.config.getInt("crafting", UPGRADES, 5, 0, Integer.MAX_VALUE, "The additional energy used per Crafting Upgrade");
        this.stackUpgradeUsage = this.config.getInt("stack", UPGRADES, 12, 0, Integer.MAX_VALUE, "The additional energy used per Stack Upgrade");
        this.interdimensionalUpgradeUsage = this.config.getInt("interdimensional", UPGRADES, 1000, 0, Integer.MAX_VALUE, "The additional energy used by the Interdimensional Upgrade");
        this.silkTouchUpgradeUsage = this.config.getInt("silkTouch", UPGRADES, 15, 0, Integer.MAX_VALUE, "The additional energy used by the Silk Touch Upgrade");
        this.fortuneUpgradeUsagePerFortune = this.config.getInt("fortune", UPGRADES, 10, 0, Integer.MAX_VALUE, "The additional energy used by the Fortune Upgrade, multiplied by the level of the enchantment");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(this.config.getCategory(ENERGY)).getChildElements());
        list.addAll(new ConfigElement(this.config.getCategory(CONTROLLER)).getChildElements());
        list.addAll(new ConfigElement(this.config.getCategory(UPGRADES)).getChildElements());
        list.addAll(new ConfigElement(this.config.getCategory(WIRELESS_TRANSMITTER)).getChildElements());
        list.addAll(new ConfigElement(this.config.getCategory(WIRELESS_GRID)).getChildElements());
        list.addAll(new ConfigElement(this.config.getCategory(GRID)).getChildElements());
        return list;
    }
}

