/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world;

import com.google.common.collect.Maps;
import elec332.core.world.PositionedObjectHolder;
import elec332.core.world.WorldHelper;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

@Deprecated
public class SurroundingChecker<O> {
    private final World world;
    private final PositionedObjectHolder<SurroundingData> surroundings = new PositionedObjectHolder();
    private final IFacedSurroundingDataFactory<O> surroundingDataFactory;
    private final ISurroundingHandler<O> surroundingHandler;

    public SurroundingChecker(IFacedSurroundingDataFactory<O> factory, World world, ISurroundingHandler<O> surroundingHandler) {
        this.surroundingDataFactory = factory;
        this.surroundingHandler = surroundingHandler;
        this.world = world;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addPosition(BlockPos pos) {
        if (this.surroundings.get(pos) != null) {
            throw new IllegalStateException();
        }
        this.resetPositionData(pos);
    }

    public void resetPositionData(BlockPos pos) {
        this.surroundings.put(new SurroundingData(pos), pos);
    }

    public void removePosition(BlockPos pos) {
        this.surroundings.remove(pos);
    }

    public O getSurroundingData(BlockPos pos, EnumFacing side) {
        return (O)((Pair)this.surroundings.get(pos).data.get(side)).getRight();
    }

    @SubscribeEvent
    public void onNeighborChangeEvent(BlockEvent.NeighborNotifyEvent event) {
        if (WorldHelper.getDimID(this.world) == WorldHelper.getDimID(event.getWorld())) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos pos = event.getPos().func_177972_a(facing);
                this.checkForPos(pos);
            }
            this.checkForPos(event.getPos());
        }
    }

    public boolean isChange(BlockPos pos) {
        SurroundingData oldData = this.surroundings.get(pos);
        SurroundingData newData = new SurroundingData(pos);
        boolean ret = oldData == null || newData.equalCheck(oldData, false);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (ret) {
                return ret;
            }
            BlockPos pos_ = pos.func_177972_a(facing);
            SurroundingData s = this.surroundings.get(pos_);
            if (s == null) continue;
            ret |= new SurroundingData(pos).equalCheck(s, false);
        }
        return ret;
    }

    private void checkForPos(BlockPos pos) {
        SurroundingData oldData = this.surroundings.get(pos);
        if (oldData != null) {
            SurroundingData newData = new SurroundingData(pos);
            newData.equalCheck(oldData, true);
            this.surroundings.put(newData, pos);
        }
    }

    private class SurroundingData {
        private final BlockPos pos;
        private final Map<EnumFacing, Pair<Block, O>> data;
        private int hash;

        private SurroundingData(BlockPos pos) {
            this.pos = pos;
            this.data = Maps.newEnumMap(EnumFacing.class);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                Object s = SurroundingChecker.this.surroundingDataFactory.generateFor(SurroundingChecker.this.world, pos, facing);
                this.data.put(facing, Pair.of((Object)WorldHelper.getBlockAt((IBlockAccess)SurroundingChecker.this.world, pos.func_177972_a(facing)), s));
                this.hash += facing.ordinal() * s.hashCode();
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass() && this.equalCheck((SurroundingData)obj, false);
        }

        private boolean equalCheck(SurroundingData oldSurroundingData, boolean notify) {
            boolean ret = true;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                Pair oldO = oldSurroundingData.data.get(facing);
                Pair newO = this.data.get(facing);
                if (SurroundingChecker.this.surroundingDataFactory.equal(newO.getRight(), oldO.getRight())) continue;
                if (notify) {
                    ret = false;
                    SurroundingChecker.this.surroundingHandler.onSurroundingsChanged(this.pos, facing, oldO.getRight(), newO.getRight(), oldO.getLeft() != newO.getLeft());
                    continue;
                }
                return false;
            }
            return ret;
        }
    }

    public static interface IFacedSurroundingDataFactory<O> {
        public O generateFor(World var1, BlockPos var2, EnumFacing var3);

        public boolean equal(O var1, O var2);
    }

    public static interface ISurroundingHandler<O> {
        public void onSurroundingsChanged(BlockPos var1, EnumFacing var2, @Nullable O var3, @Nullable O var4, boolean var5);
    }
}

