/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.proxies;

import elec332.core.api.client.IColoredBlock;
import elec332.core.api.client.IColoredItem;
import elec332.core.client.model.ModelEventHandler;
import elec332.core.client.model.loading.handler.ElecModelHandler;
import elec332.core.client.model.replace.ElecTileEntityItemStackRenderer;
import elec332.core.inventory.window.WindowGui;
import elec332.core.main.ElecCore;
import elec332.core.proxies.CommonProxy;
import elec332.core.util.RegistryHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private static final IItemColor COLORED_ITEM = new IItemColor(){

        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            return ((IColoredItem)stack.func_77973_b()).getColorFromItemStack(stack, tintIndex);
        }
    };
    private static final IItemColor COLORED_ITEMBLOCK = new IItemColor(){

        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            return ((IColoredBlock)block).colorMultiplier(block.func_176203_a(stack.func_77952_i()), null, null, tintIndex);
        }
    };
    private static final IBlockColor COLORED_BLOCK = new IBlockColor(){

        public int func_186720_a(@Nonnull IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
            return ((IColoredBlock)state.func_177230_c()).colorMultiplier(state, worldIn, pos, tintIndex);
        }
    };

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void preInitRendering() {
        IResourceManager resourceManager = this.minecraft.func_110442_L();
        if (!(resourceManager instanceof SimpleReloadableResourceManager)) {
            ElecCore.logger.error("Someone replaced the resource manager, but it doesn't extend SimpleResourceManager!");
            ElecCore.logger.error("This is an severe error, forge will crash further down the line, exiting minecraft now!");
            ElecCore.logger.error("Source: " + resourceManager.getClass().getCanonicalName());
            throw new RuntimeException("Class: " + resourceManager.getClass().getCanonicalName() + " is not a valid replacement for the vanilla resource manager.");
        }
        ((SimpleReloadableResourceManager)resourceManager).func_110542_a((IResourceManagerReloadListener)new ModelReloadListener());
        MinecraftForge.EVENT_BUS.register((Object)new ModelEventHandler());
    }

    @Override
    public void postInitRendering() {
        for (Item item : RegistryHelper.getItemRegistry()) {
            if (item instanceof IColoredItem) {
                this.minecraft.field_184128_aI.func_186730_a(COLORED_ITEM, new Item[]{item});
            }
            if (!(item instanceof ItemBlock)) continue;
            Block block = ((ItemBlock)item).func_179223_d();
            if (block instanceof IColoredItem) {
                this.minecraft.field_184128_aI.func_186731_a(COLORED_ITEM, new Block[]{block});
                continue;
            }
            if (!(block instanceof IColoredBlock)) continue;
            this.minecraft.field_184128_aI.func_186730_a(COLORED_ITEMBLOCK, new Item[]{item});
        }
        for (Block block : RegistryHelper.getBlockRegistry()) {
            if (!(block instanceof IColoredBlock)) continue;
            this.minecraft.field_184127_aH.func_186722_a(COLORED_BLOCK, new Block[]{block});
        }
        TileEntityItemStackRenderer.field_147719_a = new ElecTileEntityItemStackRenderer(TileEntityItemStackRenderer.field_147719_a);
    }

    @Override
    public void addPersonalMessageToPlayer(String s) {
        this.getClientPlayer().func_145747_a((ITextComponent)new TextComponentString(s));
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public synchronized Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new WindowGui(super.getServerGuiElement(ID, player, world, x, y, z));
    }

    private class ModelReloadListener
    implements IResourceManagerReloadListener {
        private ModelReloadListener() {
        }

        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
            if (((ClientProxy)ClientProxy.this).minecraft.field_175621_X != null) {
                ElecModelHandler.registerModels();
            }
        }
    }
}

