/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget;

import elec332.core.client.RenderHelper;
import elec332.core.client.util.GuiDraw;
import elec332.core.inventory.tooltip.ToolTip;
import elec332.core.inventory.widget.IWidgetListener;
import elec332.core.inventory.widget.Widget;
import elec332.core.inventory.window.Window;
import elec332.core.util.MathHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class FluidTankWidget
extends Widget {
    private IFluidTank tank;
    private FluidStack fluidStack;
    private int capacity;

    public FluidTankWidget(int x, int y, int u, int v, int width, int height, IFluidTank tank) {
        super(x, y, u, v, width, height);
        this.tank = tank;
        if (height < 11) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void detectAndSendChanges(Iterable<IWidgetListener> crafters) {
        if (this.capacity != this.tank.getCapacity() || this.fluidStack != null && !this.fluidStack.isFluidStackIdentical(this.tank.getFluid()) || this.tank.getFluid() != null) {
            for (IWidgetListener iCrafting : crafters) {
                if (!(iCrafting instanceof EntityPlayerMP)) continue;
                NBTTagCompound tag = new NBTTagCompound();
                if (this.tank.getFluid() != null) {
                    this.tank.getFluid().writeToNBT(tag);
                }
                tag.func_74768_a("capacity_TANK", this.tank.getCapacity());
                this.sendNBTChangesToPlayer((EntityPlayerMP)iCrafting, tag);
            }
            this.capacity = this.tank.getCapacity();
            this.fluidStack = this.tank.getFluid() == null ? null : this.tank.getFluid().copy();
        }
    }

    @Override
    public ToolTip getToolTip() {
        String fluid = this.fluidStack == null || this.fluidStack.getFluid() == null ? null : this.fluidStack.getFluid().getName();
        int amount = this.fluidStack == null ? 0 : this.fluidStack.amount;
        return new ToolTip(new ToolTip.ColouredString("Fluid: " + fluid + "  Amount: " + amount));
    }

    @Override
    public void readNBTChangesFromPacket(NBTTagCompound tagCompound) {
        this.fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
        this.capacity = tagCompound.func_74762_e("capacity_TANK");
    }

    @Override
    public void draw(Window gui, int guiX, int guiY, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        this.drawFluid(guiX, guiY);
        GlStateManager.func_179121_F();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int rH = this.height - 11 + 1;
        int p = rH % 6;
        float scale = (float)this.fluidStack.amount / (float)this.capacity;
        if (p == 0) {
            GuiDraw.drawTexturedModalRect(guiX + this.x, guiY + this.y, 180, 70, this.width > 12 ? 12 : this.width, this.height <= 46 ? this.height : 46);
            int i = this.height - 46;
            if (i > 0) {
                for (int j = 0; j < i / 6; ++j) {
                    GuiDraw.drawTexturedModalRect(guiX + this.x, guiY + this.y + 46 + j * 6, 180, 75, this.width > 12 ? 12 : this.width, 5);
                }
            }
        } else {
            int i;
            int hS = 0;
            if (this.height >= 46) {
                GuiDraw.drawTexturedModalRect(guiX + this.x, guiY + this.y, 180, 70, this.width > 12 ? 12 : this.width, 46);
                hS = 46;
            }
            if ((i = p % 2) == 1) {
                // empty if block
            }
        }
        this.bindTexture(Window.DEFAULT_BACKGROUND);
        GuiDraw.drawTexturedModalRect(guiX + this.x, guiY + this.y - 1, this.x, this.y - 1, this.width, this.height - (int)Math.floor((float)this.height * scale) + 1);
        GuiDraw.drawTexturedModalRect(guiX + this.x, guiY + this.y, this.u, this.v, this.width, this.height);
    }

    private void drawFluid(int guiX, int guiY) {
        int col;
        if (this.capacity == 0) {
            return;
        }
        if (this.fluidStack == null || this.fluidStack.getFluid() == null || this.fluidStack.amount <= 0) {
            return;
        }
        TextureAtlasSprite fluidIcon = RenderHelper.getFluidTexture(this.fluidStack.getFluid(), false);
        this.bindTexture(RenderHelper.getBlocksResourceLocation());
        int wrT = this.width % 16;
        int hrT = this.height % 16;
        int widthTimes = MathHelper.floor_float((float)this.width / 16.0f);
        int heightTimes = MathHelper.floor_float((float)this.height / 16.0f);
        for (col = 0; col < widthTimes; ++col) {
            for (int row = 0; row <= heightTimes; ++row) {
                GuiDraw.drawTexturedModalRect(guiX + this.x + col * 16, guiY + this.y + row * 16 - 1, fluidIcon, 16, 16);
            }
        }
        if (wrT != 0) {
            for (int row = 0; row <= heightTimes; ++row) {
                GuiDraw.drawTexturedModalRect(guiX + this.x + widthTimes * 16, guiY + this.y + row * 16 - 1, fluidIcon, wrT, 16);
            }
        }
        if (hrT != 0) {
            for (col = 0; col < widthTimes; ++col) {
                GuiDraw.drawTexturedModalRect(guiX + this.x + col * 16, guiY + this.y + heightTimes * 16 - 1, fluidIcon, 16, hrT);
            }
        }
        if (hrT != 0 && wrT != 0) {
            GuiDraw.drawTexturedModalRect(guiX + this.x + widthTimes * 16, guiY + this.y + heightTimes * 16 - 1, fluidIcon, wrT, hrT);
        }
    }
}

