/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry.bee;

import com.google.common.collect.Lists;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.worldgen.HiveRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public interface IHiveEnum
extends IStringSerializable {
    @Nonnull
    default public List<IHiveDescription> getHiveDescriptions() {
        return Lists.newArrayList((Object[])new IHiveDescription[]{this.getHiveDescription()});
    }

    @Nonnull
    public IHiveDescription getHiveDescription();

    public int getMeta();

    public String getUid();

    default public boolean showInTab() {
        return true;
    }

    default public int getLight() {
        return 0;
    }

    @Nonnull
    default public String func_176610_l() {
        return this.toString().toLowerCase(Locale.ENGLISH);
    }

    default public void addDrop(IHiveDrop ... drops) {
        HiveManager.hiveRegistry.addDrops(this.getUid(), drops);
    }

    @Nonnull
    default public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        IBee bee;
        ArrayList ret = Lists.newArrayList();
        Random random = world instanceof World ? ((World)world).field_73012_v : new Random(pos.func_177986_g());
        List hiveDrops = ((HiveRegistry)HiveManager.hiveRegistry).getDrops(this.getUid());
        Collections.shuffle(hiveDrops);
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : hiveDrops) {
                if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
                bee = drop.getBeeType(world, pos);
                if ((double)random.nextFloat() < drop.getIgnobleChance(world, pos, fortune)) {
                    bee.setIsNatural(false);
                }
                ItemStack princess = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.PRINCESS);
                ret.add(princess);
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            bee = drop.getBeeType(world, pos);
            ItemStack drone = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.DRONE);
            ret.add(drone);
            break;
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            ret.addAll(drop.getExtraItems(world, pos, fortune));
            break;
        }
        return ret;
    }
}

