/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry;

import elec332.core.compat.forestry.IGenomeTemplate;
import elec332.core.compat.forestry.IIndividualBranch;
import elec332.core.compat.forestry.IIndividualDefinition;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpeciesBuilder;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public interface IIndividualTemplate<T extends IGenomeTemplate, B extends IAlleleSpeciesBuilder, G extends IGenome, I extends IIndividual, S extends ISpeciesType, R extends ISpeciesRoot>
extends IIndividualDefinition<G, I, S> {
    @Nonnull
    public String getUid();

    public boolean isDominant();

    @Nonnull
    default public String getAuthority() {
        return "Elec332";
    }

    @Nonnull
    public String getUnlocalizedName();

    @Nonnull
    default public String getUnlocalizedDescription() {
        return this.getUnlocalizedName() + ".description";
    }

    @Nonnull
    public String getBinominalName();

    @Nonnull
    public Class<T> getGenomeTemplateType();

    @Nonnull
    public R getSpeciesRoot();

    @Nonnull
    public B getSpeciesBuilder();

    @Nonnull
    public IIndividualBranch<T> getIndividualBranch();

    public void modifyGenomeTemplate(T var1);

    public void setSpeciesProperties(B var1);

    public void registerMutations();

    default public boolean isActive() {
        return true;
    }

    public void setIndividualDefinition(IIndividualDefinition<G, I, S> var1);

    public IIndividualDefinition<G, I, S> getIndividualDefinition();

    @Override
    @Nonnull
    default public G getGenome() {
        return this.getIndividualDefinition().getGenome();
    }

    @Override
    @Nonnull
    default public IAllele[] getAlleles() {
        return this.getIndividualDefinition().getAlleles();
    }

    @Override
    default public I getIndividual() {
        return this.getIndividualDefinition().getIndividual();
    }

    @Override
    default public ItemStack getMemberStack(S speciesType) {
        return this.getIndividualDefinition().getMemberStack(speciesType);
    }
}

