/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry;

import elec332.core.api.client.ITextureLoader;
import elec332.core.api.module.ElecModule;
import elec332.core.client.model.RenderingRegistry;
import elec332.core.client.model.loading.IModelLoader;
import elec332.core.compat.forestry.ForestryAlleles;
import elec332.core.compat.forestry.IGenomeTemplate;
import elec332.core.compat.forestry.IIndividualTemplate;
import elec332.core.compat.forestry.IndividualDefinitionRegistry;
import elec332.core.compat.forestry.bee.ForestryBeeEffects;
import elec332.core.java.ReflectionHelper;
import elec332.core.main.ElecCore;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeModelProvider;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleHandler;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.genetics.alleles.AlleleBeeSpecies;
import forestry.plugins.IForestryPlugin;
import forestry.plugins.PluginManager;
import java.lang.reflect.Field;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

@ElecModule(owner="eleccore", name="ForestryCompat", modDependencies="forestry@[5.2.9.241,)")
public class ForestryCompatHandler {
    public static IBeeRoot beeRoot;
    private static CreativeTabs tabBees;

    public static CreativeTabs getForestryBeeTab() {
        return tabBees;
    }

    @ElecModule.EventHandler
    public void preInit(FMLInitializationEvent event) {
        beeRoot = BeeManager.beeRoot;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            AlleleManager.alleleRegistry.registerAlleleHandler(new IAlleleHandler(){

                public void onRegisterAllele(IAllele allele) {
                    if (allele instanceof IModelLoader) {
                        RenderingRegistry.instance().registerLoader((IModelLoader)allele);
                    }
                    if (allele instanceof ITextureLoader) {
                        RenderingRegistry.instance().registerLoader((ITextureLoader)allele);
                    }
                    if (allele instanceof AlleleBeeSpecies) {
                        try {
                            Field f = ReflectionHelper.makeFieldAccessible(AlleleBeeSpecies.class.getDeclaredField("beeModelProvider"));
                            IBeeModelProvider modelProvider = (IBeeModelProvider)f.get(allele);
                            if (modelProvider instanceof IModelLoader) {
                                RenderingRegistry.instance().registerLoader((IModelLoader)allele);
                            }
                            if (modelProvider instanceof ITextureLoader) {
                                RenderingRegistry.instance().registerLoader((ITextureLoader)allele);
                            }
                        }
                        catch (Exception e) {
                            ElecCore.logger.error("Error checking bee ModelProvider");
                        }
                    }
                }

                public void onRegisterClassification(IClassification classification) {
                }

                public void onRegisterFruitFamily(IFruitFamily family) {
                }
            });
        }
        tabBees = Tabs.tabApiculture;
        for (IForestryPlugin plugin : PluginManager.getLoadedPlugins()) {
            if (!(plugin instanceof PluginApiculture)) continue;
            ForestryAlleles.dummyLoad();
            ForestryBeeEffects.init();
            break;
        }
    }

    @ElecModule.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        IndividualDefinitionRegistry.locked = true;
        for (IIndividualTemplate iIndividualTemplate : IndividualDefinitionRegistry.templates) {
            Object allele;
            if (iIndividualTemplate.isActive()) {
                iIndividualTemplate.registerMutations();
                continue;
            }
            try {
                allele = ((IGenomeTemplate)iIndividualTemplate.getGenomeTemplateType().newInstance()).getSpecies(iIndividualTemplate.getAlleles());
            }
            catch (Exception e) {
                ElecCore.logger.info("Error invocating class: " + iIndividualTemplate.getGenomeTemplateType().getCanonicalName());
                ElecCore.logger.info("Attempting backup method to fetch species allele...");
                allele = (IAlleleSpecies)iIndividualTemplate.getAlleles()[0];
            }
            AlleleManager.alleleRegistry.blacklistAllele(allele.getUID());
        }
        IndividualDefinitionRegistry.registeredClasses.clear();
        IndividualDefinitionRegistry.registeredTemplates.clear();
    }
}

