/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.loading.handler;

import com.google.common.collect.ImmutableList;
import elec332.core.api.client.model.loading.IItemModelHandler;
import elec332.core.api.client.model.loading.ModelHandler;
import elec332.core.client.RenderHelper;
import elec332.core.client.model.loading.INoJsonItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ModelHandler
@SideOnly(value=Side.CLIENT)
public class INoJsonItemHandler
implements IItemModelHandler {
    private final IBakedModel modelItemLink = new LinkedItemModel();
    private final IBakedModel modelItemBlockLink = new LinkedItemBlockModel();

    @Override
    public boolean handleItem(Item item) {
        return item instanceof INoJsonItem || item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof INoJsonItem;
    }

    @Override
    public String getIdentifier(Item item) {
        return "inventory";
    }

    @Override
    public IBakedModel getModelFor(Item item, String identifier, ModelResourceLocation fullResourceLocation) {
        return item instanceof INoJsonItem ? this.modelItemLink : this.modelItemBlockLink;
    }

    private class NullModel
    implements IBakedModel {
        private final ItemOverrideList iol;

        private NullModel(ItemOverrideList iol) {
            this.iol = iol;
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(IBlockState p_188616_1_, EnumFacing p_188616_2_, long p_188616_3_) {
            throw new UnsupportedOperationException();
        }

        public boolean func_177555_b() {
            throw new UnsupportedOperationException();
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return RenderHelper.getMissingTextureIcon();
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return this.iol;
        }
    }

    private class NoJsonItemOverrideList
    extends ItemOverrideList {
        private final INoJsonItem item;

        private NoJsonItemOverrideList(INoJsonItem item) {
            super((List)ImmutableList.of());
            this.item = item;
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            return this.item.getItemModel(stack, world, entity);
        }
    }

    private class LinkedItemBlockModel
    extends NullModel {
        private LinkedItemBlockModel() {
            super(new NoJsonItemOverrideList(null){

                @Override
                @Nonnull
                public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    return ((INoJsonItem)((ItemBlock)stack.func_77973_b()).func_179223_d()).getItemModel(stack, world, entity);
                }
            });
        }
    }

    private class LinkedItemModel
    extends NullModel {
        private LinkedItemModel() {
            super(new NoJsonItemOverrideList(null){

                @Override
                @Nonnull
                public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    return ((INoJsonItem)stack.func_77973_b()).getItemModel(stack, world, entity);
                }
            });
        }
    }
}

