/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.loading.handler;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.api.client.model.loading.IModelHandler;
import elec332.core.api.client.model.loading.ModelHandler;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IASMDataProcessor;
import elec332.core.main.ElecCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@ASMDataProcessor(value={LoaderState.PREINITIALIZATION})
public final class ElecModelHandler
implements IASMDataProcessor {
    private static List<IModelHandler> modelHandlers = Lists.newArrayList();

    @Override
    public void processASMData(IASMDataHelper asmData, LoaderState state) {
        ArrayList list = Lists.newArrayList();
        for (ASMDataTable.ASMData data : asmData.getAnnotationList(ModelHandler.class)) {
            String s = data.getClassName();
            try {
                list.add(Class.forName(s).newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Error registering ModelHandler class: " + s, e);
            }
        }
        ImmutableList param = ImmutableList.copyOf((Collection)list);
        for (Object o : list) {
            IModelHandler modelHandler;
            if (!(o instanceof IModelHandler) || !(modelHandler = (IModelHandler)o).enabled()) continue;
            modelHandlers.add(modelHandler);
            modelHandler.getModelHandlers((List<?>)param);
        }
    }

    public static void registerModels() {
        for (IModelHandler modelHandler : modelHandlers) {
            modelHandler.registerModels();
        }
    }

    public static Set<ModelResourceLocation> registerBakedModels(final IRegistry<ModelResourceLocation, IBakedModel> registry) {
        ElecCore.logger.info("Handling models");
        HashSet ret = Sets.newHashSet();
        IBakedModel missingModel = (IBakedModel)registry.func_82594_a((Object)ModelBakery.field_177604_a);
        HashMap models = Maps.newHashMap();
        for (IModelHandler iModelHandler : modelHandlers) {
            models.putAll(iModelHandler.registerBakedModels(new Function<ModelResourceLocation, IBakedModel>(){

                @Override
                public IBakedModel apply(ModelResourceLocation modelResourceLocation) {
                    return (IBakedModel)registry.func_82594_a((Object)modelResourceLocation);
                }
            }));
        }
        for (Map.Entry entry : models.entrySet()) {
            registry.func_82595_a(entry.getKey(), Objects.firstNonNull(entry.getValue(), (Object)missingModel));
            ret.add(entry.getKey());
        }
        return ret;
    }
}

