/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import elec332.core.api.client.model.IElecQuadBakery;
import elec332.core.api.client.model.model.IQuadProvider;
import elec332.core.api.client.model.template.IQuadTemplate;
import elec332.core.api.client.model.template.IQuadTemplateSidedMap;
import elec332.core.client.model.ElecModelBakery;
import elec332.core.client.model.ModelLoadEventImpl;
import elec332.core.client.model.template.ElecTemplateBakery;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class ElecQuadBakery
implements IElecQuadBakery {
    protected static final ElecQuadBakery instance = new ElecQuadBakery();
    private final FaceBakery faceBakery = new FaceBakery();
    private static final List<BakedQuad> EMPTY_LIST = ImmutableList.of();

    private ElecQuadBakery() {
    }

    @Override
    public IQuadProvider bakeQuads(IQuadTemplateSidedMap from) {
        return this.bakeQuads(from, null);
    }

    @Override
    public IQuadProvider bakeQuads(IQuadTemplateSidedMap from, ITransformation rotation) {
        SidedMap ret = new SidedMap();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            ret.setQuadsForSide(rotation == null ? facing : rotation.rotate(facing), this.bakeQuads(from.getForSide(facing), rotation));
        }
        return ret;
    }

    @Override
    public List<BakedQuad> bakeQuads(List<IQuadTemplate> from) {
        return this.bakeQuads(from, null);
    }

    @Override
    public List<BakedQuad> bakeQuads(List<IQuadTemplate> from, ITransformation rotation) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (IQuadTemplate quadTemplate : from) {
            builder.add((Object)this.bakeQuad(quadTemplate, (ITransformation)(rotation == null ? quadTemplate.getRotation() : rotation)));
        }
        return builder.build();
    }

    @Override
    public BakedQuad bakeQuad(Vector3f v1, Vector3f v2, TextureAtlasSprite texture, EnumFacing facing) {
        return this.bakeQuad(v1, v2, texture, facing, (ITransformation)ModelRotation.X0_Y0);
    }

    @Override
    public BakedQuad bakeQuad(Vector3f v1, Vector3f v2, TextureAtlasSprite texture, EnumFacing facing, ITransformation rotation) {
        return this.bakeQuad(v1, v2, texture, facing, rotation, 0.0f, 0.0f, 16.0f, 16.0f);
    }

    @Override
    public BakedQuad bakeQuad(Vector3f v1, Vector3f v2, TextureAtlasSprite texture, EnumFacing facing, ITransformation rotation, float f1, float f2, float f3, float f4) {
        return this.bakeQuad(v1, v2, texture, facing, rotation, f1, f2, f3, f4, -1);
    }

    @Override
    public BakedQuad bakeQuad(IQuadTemplate template) {
        return this.bakeQuad(template, (ITransformation)template.getRotation());
    }

    @Override
    public BakedQuad bakeQuad(IQuadTemplate template, ITransformation rotation) {
        return this.bakeQuad(template.getV1(), template.getV2(), template.getTexture(), template.getSide(), rotation, template.getUVData(), template.getTintIndex());
    }

    @Override
    public BakedQuad bakeQuad(Vector3f v1, Vector3f v2, TextureAtlasSprite texture, EnumFacing facing, ITransformation rotation, IQuadTemplate.IUVData uvData, int tint) {
        return this.bakeQuad(v1, v2, texture, facing, rotation, uvData.getUMin(), uvData.getVMin(), uvData.getUMax(), uvData.getVMax(), tint);
    }

    @Override
    public BakedQuad bakeQuad(Vector3f v1, Vector3f v2, TextureAtlasSprite texture, EnumFacing facing, ITransformation rotation, float f1, float f2, float f3, float f4, int tint) {
        BlockFaceUV bfuv = new BlockFaceUV(new float[]{f1, f2, f3, f4}, ((ModelRotation)rotation).field_177543_t * 90);
        BlockPartFace bpf = new BlockPartFace(rotation.rotate(facing), tint, null, bfuv);
        return this.faceBakery.makeBakedQuad(v1, v2, bpf, texture, facing, rotation, null, false, true);
    }

    @Override
    public List<BakedQuad> getGeneralItemQuads(TextureAtlasSprite ... textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.length; ++i) {
            builder.addAll((Iterable)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)textures[i], (VertexFormat)DefaultVertexFormats.field_176599_b, (Optional)Optional.of((Object)TRSRTransformation.identity())));
        }
        return builder.build();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @SideOnly(value=Side.CLIENT)
    public void bakeModels(ModelBakeEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)new ModelLoadEventImpl(this, ElecModelBakery.instance, ElecTemplateBakery.instance, (IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry()));
    }

    private class SidedMap
    implements IQuadProvider {
        private final EnumMap<EnumFacing, List<BakedQuad>> quads;

        private SidedMap() {
            this(Maps.newEnumMap(EnumFacing.class));
        }

        private SidedMap(EnumMap<EnumFacing, List<BakedQuad>> quads) {
            this.quads = quads;
        }

        public void setQuadsForSide(EnumFacing side, List<BakedQuad> newQuads) {
            this.quads.put(side, newQuads);
        }

        @Override
        public List<BakedQuad> getBakedQuads(@Nullable IBlockState state, EnumFacing side, long random) {
            List ret = this.quads.get(side);
            if (ret == null) {
                ret = EMPTY_LIST;
            }
            return ret;
        }
    }
}

