/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mcjty.lib.network.NetworkTools;

public class ByteBufTools {
    public static void writeMapAsStrings(ByteBuf buf, Map<String, String> s) {
        if (s == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(s.size());
            s.entrySet().stream().forEach(entry -> {
                NetworkTools.writeString((ByteBuf)buf, (String)((String)entry.getKey()));
                NetworkTools.writeString((ByteBuf)buf, (String)((String)entry.getValue()));
            });
        }
    }

    public static Map<String, String> readMapFromStrings(ByteBuf buf) {
        int size = buf.readInt();
        if (size == -1) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = NetworkTools.readString((ByteBuf)buf);
            String value = NetworkTools.readString((ByteBuf)buf);
            result.put(key, value);
        }
        return result;
    }

    public static <T> void writeSetAsStrings(ByteBuf buf, Set<T> s) {
        if (s == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(s.size());
            s.stream().forEach(p -> NetworkTools.writeString((ByteBuf)buf, (String)p.toString()));
        }
    }

    public static Set<String> readSetFromStrings(ByteBuf buf) {
        return ByteBufTools.readSetFromStringsWithMapper(buf, p -> p);
    }

    public static <T> Set<T> readSetFromStringsWithMapper(ByteBuf buf, Function<String, T> mapper) {
        int size = buf.readInt();
        if (size == -1) {
            return null;
        }
        HashSet<T> result = new HashSet<T>(size);
        for (int i = 0; i < size; ++i) {
            result.add(mapper.apply(NetworkTools.readString((ByteBuf)buf)));
        }
        return result;
    }

    public static <T extends Enum> void writeSetAsEnums(ByteBuf buf, Set<T> s) {
        if (s == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(s.size());
            s.stream().forEach(p -> buf.writeShort(p.ordinal()));
        }
    }

    public static <T> Set<T> readSetFromShortsWithMapper(ByteBuf buf, Function<Integer, T> mapper) {
        int size = buf.readInt();
        if (size == -1) {
            return null;
        }
        HashSet<T> result = new HashSet<T>(size);
        for (int i = 0; i < size; ++i) {
            result.add(mapper.apply(Integer.valueOf(buf.readShort())));
        }
        return result;
    }

    public static void writeSetAsShorts(ByteBuf buf, Set<Integer> s) {
        if (s == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(s.size());
            s.stream().forEach(p -> buf.writeShort(p.intValue()));
        }
    }

    public static Set<Integer> readSetFromShorts(ByteBuf buf) {
        int size = buf.readInt();
        if (size == -1) {
            return null;
        }
        HashSet<Integer> result = new HashSet<Integer>(size);
        for (int i = 0; i < size; ++i) {
            result.add(Integer.valueOf(buf.readShort()));
        }
        return result;
    }
}

