/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.types;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.tools.BiomeTools;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public enum ControllerType {
    CONTROLLER_DEFAULT("Default", 0, null),
    CONTROLLER_SINGLE("Single", 1, null),
    CONTROLLER_CHECKERBOARD("Checker", 2, null),
    CONTROLLER_COLD("Cold", 0, new BiomeFilter(){

        @Override
        public boolean match(Biome biome) {
            return biome.func_150561_m() == Biome.TempCategory.COLD;
        }

        @Override
        public double calculateBiomeDistance(Biome a, Biome b) {
            return this.calculateBiomeDistance(a, b, false, true, false);
        }
    }),
    CONTROLLER_MEDIUM("Medium", 0, new BiomeFilter(){

        @Override
        public boolean match(Biome biome) {
            return biome.func_150561_m() == Biome.TempCategory.MEDIUM;
        }

        @Override
        public double calculateBiomeDistance(Biome a, Biome b) {
            return this.calculateBiomeDistance(a, b, false, true, false);
        }
    }),
    CONTROLLER_WARM("Warm", 0, new BiomeFilter(){

        @Override
        public boolean match(Biome biome) {
            return biome.func_150561_m() == Biome.TempCategory.WARM;
        }

        @Override
        public double calculateBiomeDistance(Biome a, Biome b) {
            return this.calculateBiomeDistance(a, b, false, true, false);
        }
    }),
    CONTROLLER_DRY("Dry", 0, new BiomeFilter(){

        @Override
        public boolean match(Biome biome) {
            return (double)biome.func_76727_i() < 0.1;
        }

        @Override
        public double calculateBiomeDistance(Biome a, Biome b) {
            return this.calculateBiomeDistance(a, b, true, false, false);
        }
    }),
    CONTROLLER_WET("Wet", 0, new BiomeFilter(){

        @Override
        public boolean match(Biome biome) {
            return biome.func_76736_e();
        }

        @Override
        public double calculateBiomeDistance(Biome a, Biome b) {
            return this.calculateBiomeDistance(a, b, true, false, false);
        }
    }),
    CONTROLLER_FIELDS("Fields", 0, new BiomeFilter(){

        @Override
        public boolean match(Biome biome) {
            float rootHeight = biome.func_185355_j();
            float heightVariation = biome.func_185360_m();
            return (double)heightVariation < 0.11 && rootHeight < 0.25f;
        }

        @Override
        public double calculateBiomeDistance(Biome a, Biome b) {
            return this.calculateBiomeDistance(a, b, false, false, true);
        }
    }),
    CONTROLLER_MOUNTAINS("Mountains", 0, new BiomeFilter(){

        @Override
        public boolean match(Biome biome) {
            float heightVariation = biome.func_185360_m();
            return heightVariation > 0.45f;
        }

        @Override
        public double calculateBiomeDistance(Biome a, Biome b) {
            return this.calculateBiomeDistance(a, b, false, false, true);
        }
    }),
    CONTROLLER_FILTERED("Filtered", -1, null),
    CONTROLLER_MAGICAL("Magical", 0, new BiomeFilter(){

        @Override
        public boolean match(Biome biome) {
            return BiomeTools.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeTools.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY);
        }

        @Override
        public double calculateBiomeDistance(Biome a, Biome b) {
            return this.calculateBiomeDistance(a, b, false, false, false);
        }
    }),
    CONTROLLER_FOREST("Forest", 0, new BiomeFilter(){

        @Override
        public boolean match(Biome biome) {
            return biome.field_76760_I.field_76832_z >= 5;
        }

        @Override
        public double calculateBiomeDistance(Biome a, Biome b) {
            return this.calculateBiomeDistance(a, b, false, false, false);
        }
    });

    private static final Map<String, ControllerType> CONTROLLER_TYPE_MAP;
    private final String id;
    private final int neededBiomes;
    private final BiomeFilter filter;

    private ControllerType(String id, int neededBiomes, BiomeFilter filter) {
        this.id = id;
        this.neededBiomes = neededBiomes;
        this.filter = filter;
    }

    public String getId() {
        return this.id;
    }

    public static ControllerType getControllerById(String id) {
        return CONTROLLER_TYPE_MAP.get(id);
    }

    public int getNeededBiomes() {
        return this.neededBiomes;
    }

    public BiomeFilter getFilter() {
        return this.filter;
    }

    static {
        CONTROLLER_TYPE_MAP = new HashMap<String, ControllerType>();
        for (ControllerType type : ControllerType.values()) {
            CONTROLLER_TYPE_MAP.put(type.getId(), type);
        }
    }

    public static abstract class BiomeFilter {
        public abstract boolean match(Biome var1);

        public abstract double calculateBiomeDistance(Biome var1, Biome var2);

        public double calculateBiomeDistance(Biome a, Biome b, boolean ignoreRain, boolean ignoreTemperature, boolean ignoreHeight) {
            float dr = a.func_76727_i() - b.func_76727_i();
            if (ignoreRain) {
                dr = 0.0f;
            }
            float dt = a.func_185353_n() - b.func_185353_n();
            if (ignoreTemperature) {
                dt = 0.0f;
            }
            float dv = a.func_185360_m() - b.func_185360_m();
            float dh = a.func_185355_j() - b.func_185355_j();
            if (ignoreHeight) {
                dv = 0.0f;
                dh = 0.0f;
            }
            return Math.sqrt(dr * dr + dt * dt + dv * dv + dh * dh);
        }
    }
}

