/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.commands;

import java.io.File;
import java.io.IOException;
import mcjty.lib.compat.CompatCommandBase;
import mcjty.lib.tools.ChatTools;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.commands.AbstractRfToolsCommand;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.FileUtils;

public class CmdSafeDelete
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<dimension>";
    }

    @Override
    public String getCommand() {
        return "safedel";
    }

    @Override
    public int getPermissionLevel() {
        return GeneralConfiguration.playersCanDeleteDimensions ? 0 : 3;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "The dimension parameter is missing!"));
            return;
        }
        if (args.length > 2) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "Too many parameters!"));
            return;
        }
        int dim = this.fetchInt(sender, args, 1, 0);
        World world = sender.func_130014_f_();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        if (dimensionManager.getDimensionDescriptor(dim) == null) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "Not an RFTools dimension!"));
            return;
        }
        WorldServer w = DimensionManager.getWorld((int)dim);
        if (w != null) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "Dimension is still in use!"));
            return;
        }
        if (!CompatCommandBase.canUseCommand((ICommandSender)sender, (int)3, (String)"safedel")) {
            DimensionInformation information = dimensionManager.getDimensionInformation(dim);
            if (information.getOwner() == null) {
                ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "This dimension has no owner. You cannot delete it!"));
                return;
            }
            if (!(sender instanceof EntityPlayerMP)) {
                ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "This command must be run as a player!"));
                return;
            }
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)sender;
            if (!information.getOwner().equals(entityPlayerMP.func_146103_bH().getId())) {
                ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "You are not the owner of this dimension. You cannot delete it!"));
                return;
            }
        }
        RFToolsDim.teleportationManager.removeReceiverDestinations(world, dim);
        dimensionManager.removeDimension(dim);
        dimensionManager.reclaimId(dim);
        dimensionManager.save(world);
        DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(world);
        dimensionStorage.removeDimension(dim);
        dimensionStorage.save(world);
        if (GeneralConfiguration.dimensionFolderIsDeletedWithSafeDel) {
            File rootDirectory = DimensionManager.getCurrentSaveRootDirectory();
            try {
                FileUtils.deleteDirectory((File)new File(rootDirectory.getPath() + File.separator + "RFTOOLS" + dim));
                ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString("Dimension deleted and dimension folder succesfully wiped!"));
            }
            catch (IOException e) {
                ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "Dimension deleted but dimension folder could not be completely wiped!"));
            }
        } else {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString("Dimension deleted. Please remove the dimension folder from disk!"));
        }
    }
}

