/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.gendustry.forestry;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILeafTranslator;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterflyRoot;
import java.util.Collection;
import java.util.Random;
import net.bdew.gendustry.Gendustry$;
import net.bdew.gendustry.api.EnumMutationSetting;
import net.bdew.gendustry.config.Items$;
import net.bdew.gendustry.forestry.GeneSampleInfo;
import net.bdew.gendustry.items.GeneTemplate$;
import net.bdew.gendustry.machines.mutatron.MachineMutatron$;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

public final class GeneticsHelper$ {
    public static final GeneticsHelper$ MODULE$;
    private final Random random;

    static {
        new GeneticsHelper$();
    }

    public Random random() {
        return this.random;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkIndividualType(ISpeciesRoot root, ItemStack stack, int slot) {
        Tuple2 tuple2 = new Tuple2((Object)root, (Object)BoxesRunTime.boxToInteger((int)slot));
        if (tuple2 != null) {
            ISpeciesRoot bees = (ISpeciesRoot)tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (bees instanceof IBeeRoot) {
                IBeeRoot iBeeRoot = (IBeeRoot)bees;
                if (0 == n) {
                    EnumBeeType enumBeeType = iBeeRoot.getType(stack);
                    EnumBeeType enumBeeType2 = EnumBeeType.PRINCESS;
                    if (enumBeeType != null) {
                        if (!enumBeeType.equals(enumBeeType2)) return false;
                        return true;
                    }
                    if (enumBeeType2 == null) return true;
                    return false;
                }
            }
        }
        if (tuple2 != null) {
            ISpeciesRoot bees = (ISpeciesRoot)tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (bees instanceof IBeeRoot) {
                IBeeRoot iBeeRoot = (IBeeRoot)bees;
                if (1 == n) {
                    EnumBeeType enumBeeType = iBeeRoot.getType(stack);
                    EnumBeeType enumBeeType3 = EnumBeeType.DRONE;
                    if (enumBeeType != null) {
                        if (!enumBeeType.equals(enumBeeType3)) return false;
                        return true;
                    }
                    if (enumBeeType3 == null) return true;
                    return false;
                }
            }
        }
        if (tuple2 != null) {
            ISpeciesRoot trees = (ISpeciesRoot)tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (trees instanceof ITreeRoot) {
                ITreeRoot iTreeRoot = (ITreeRoot)trees;
                if (0 == n) {
                    EnumGermlingType enumGermlingType = iTreeRoot.getType(stack);
                    EnumGermlingType enumGermlingType2 = EnumGermlingType.SAPLING;
                    if (enumGermlingType != null) {
                        if (!enumGermlingType.equals(enumGermlingType2)) return false;
                        return true;
                    }
                    if (enumGermlingType2 == null) return true;
                    return false;
                }
            }
        }
        if (tuple2 == null) return true;
        ISpeciesRoot trees = (ISpeciesRoot)tuple2._1();
        int n = tuple2._2$mcI$sp();
        if (!(trees instanceof ITreeRoot)) return true;
        ITreeRoot iTreeRoot = (ITreeRoot)trees;
        if (1 != n) return true;
        EnumGermlingType enumGermlingType = iTreeRoot.getType(stack);
        EnumGermlingType enumGermlingType3 = EnumGermlingType.POLLEN;
        if (enumGermlingType != null) {
            if (!enumGermlingType.equals(enumGermlingType3)) return false;
            return true;
        }
        if (enumGermlingType3 == null) return true;
        return false;
    }

    public boolean isValidItemForSlot(ItemStack stack, int slot) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
        if (root == null) {
            return false;
        }
        return this.checkIndividualType(root, stack, slot);
    }

    public boolean checkMutation(IMutation m, IAlleleSpecies s1, IAlleleSpecies s2) {
        IAlleleSpecies iAlleleSpecies = m.getAllele0();
        IAlleleSpecies iAlleleSpecies2 = s1;
        if (!(iAlleleSpecies != null ? !iAlleleSpecies.equals(iAlleleSpecies2) : iAlleleSpecies2 != null)) {
            IAlleleSpecies iAlleleSpecies3 = m.getAllele1();
            IAlleleSpecies iAlleleSpecies4 = s2;
            if (!(iAlleleSpecies3 != null ? !iAlleleSpecies3.equals(iAlleleSpecies4) : iAlleleSpecies4 != null)) {
                return true;
            }
        }
        IAlleleSpecies iAlleleSpecies5 = m.getAllele0();
        IAlleleSpecies iAlleleSpecies6 = s2;
        if (!(iAlleleSpecies5 != null ? !iAlleleSpecies5.equals(iAlleleSpecies6) : iAlleleSpecies6 != null)) {
            IAlleleSpecies iAlleleSpecies7 = m.getAllele1();
            IAlleleSpecies iAlleleSpecies8 = s1;
            if (!(iAlleleSpecies7 != null ? !iAlleleSpecies7.equals(iAlleleSpecies8) : iAlleleSpecies8 != null)) {
                return true;
            }
        }
        return false;
    }

    public Seq<IMutation> getValidMutations(ItemStack fromStack, ItemStack toStack, IBeeHousing beeHousing) {
        Seq emptyMutations = (Seq)Seq$.MODULE$.empty();
        if (fromStack == null || toStack == null) {
            return emptyMutations;
        }
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(fromStack);
        if (root != null && root.isMember(toStack)) {
            if (this.checkIndividualType(root, fromStack, 0)) {
                if (this.checkIndividualType(root, toStack, 1)) {
                    IIndividual fromIndividual = root.getMember(fromStack);
                    IIndividual toIndividual = root.getMember(toStack);
                    if (fromIndividual == null || toIndividual == null) {
                        return emptyMutations;
                    }
                    IAlleleSpecies fromSpecies = fromIndividual.getGenome().getPrimary();
                    IAlleleSpecies toSpecies = toIndividual.getGenome().getPrimary();
                    if (fromSpecies == null || toSpecies == null) {
                        return emptyMutations;
                    }
                    Buffer mutations = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(root.getCombinations((IAllele)fromSpecies)).asScala();
                    return (Seq)((SeqLike)mutations.filter((Function1)new Serializable(fromSpecies, toSpecies){
                        private final IAlleleSpecies fromSpecies$1;
                        private final IAlleleSpecies toSpecies$1;

                        public final boolean apply(IMutation x$1) {
                            return GeneticsHelper$.MODULE$.checkMutation(x$1, this.fromSpecies$1, this.toSpecies$1);
                        }
                        {
                            this.fromSpecies$1 = fromSpecies$1;
                            this.toSpecies$1 = toSpecies$1;
                        }
                    })).toSeq().filter((Function1)new Serializable(beeHousing, fromIndividual, toIndividual, fromSpecies, toSpecies){
                        private final IBeeHousing beeHousing$1;
                        private final IIndividual fromIndividual$1;
                        private final IIndividual toIndividual$1;
                        private final IAlleleSpecies fromSpecies$1;
                        private final IAlleleSpecies toSpecies$1;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(IMutation mutation) {
                            EnumMutationSetting enumMutationSetting;
                            EnumMutationSetting enumMutationSetting2;
                            Tuple2 tuple2 = new Tuple2(MachineMutatron$.MODULE$.mutatronOverrides().apply((Object)GeneticsHelper$.MODULE$.getMutationSpecies(mutation).getUID()), (Object)mutation);
                            if (tuple2 != null && ((Object)((Object)EnumMutationSetting.ENABLED)).equals((Object)((Object)(enumMutationSetting2 = (EnumMutationSetting)((Object)tuple2._1()))))) {
                                return true;
                            }
                            if (tuple2 != null && ((Object)((Object)EnumMutationSetting.DISABLED)).equals((Object)((Object)(enumMutationSetting = (EnumMutationSetting)((Object)tuple2._1()))))) {
                                return false;
                            }
                            if (tuple2 == null) return true;
                            EnumMutationSetting enumMutationSetting3 = (EnumMutationSetting)((Object)tuple2._1());
                            IMutation beeMutation = (IMutation)tuple2._2();
                            if (!((Object)((Object)EnumMutationSetting.REQUIREMENTS)).equals((Object)((Object)enumMutationSetting3))) return true;
                            if (!(beeMutation instanceof IBeeMutation)) return true;
                            IMutation iMutation = beeMutation;
                            if (!(((IBeeMutation)iMutation).getChance(this.beeHousing$1, (IAlleleBeeSpecies)this.fromSpecies$1, (IAlleleBeeSpecies)this.toSpecies$1, (IBeeGenome)this.fromIndividual$1.getGenome(), (IBeeGenome)this.toIndividual$1.getGenome()) > 0.0f)) return false;
                            return true;
                        }
                        {
                            this.beeHousing$1 = beeHousing$1;
                            this.fromIndividual$1 = fromIndividual$1;
                            this.toIndividual$1 = toIndividual$1;
                            this.fromSpecies$1 = fromSpecies$1;
                            this.toSpecies$1 = toSpecies$1;
                        }
                    });
                }
                return emptyMutations;
            }
            return emptyMutations;
        }
        return emptyMutations;
    }

    public boolean isPotentialMutationPair(ItemStack fromStack, ItemStack toStack, IBeeHousing beeHousing) {
        if (fromStack == null && toStack == null) {
            return false;
        }
        if (toStack == null) {
            return this.isValidItemForSlot(fromStack, 0);
        }
        if (fromStack == null) {
            return this.isValidItemForSlot(toStack, 1);
        }
        return this.getValidMutations(fromStack, toStack, beeHousing).nonEmpty();
    }

    public ItemStack getMutationResult(ItemStack fromStack, ItemStack toStack, IBeeHousing beeHousing) {
        IMutation iMutation;
        Seq<IMutation> valid = this.getValidMutations(fromStack, toStack, beeHousing);
        if (valid.isEmpty()) {
            return null;
        }
        if (valid.size() > 1) {
            Seq secret = (Seq)valid.filter((Function1)new Serializable(){

                public final boolean apply(IMutation x$2) {
                    return x$2.isSecret();
                }
            });
            Seq normal = (Seq)valid.filter((Function1)new Serializable(){

                public final boolean apply(IMutation x$3) {
                    return !x$3.isSecret();
                }
            });
            iMutation = secret.nonEmpty() ? (normal.nonEmpty() ? ((float)this.random().nextInt(100) < MachineMutatron$.MODULE$.secretChance() ? (IMutation)secret.apply(this.random().nextInt(secret.size())) : (IMutation)normal.apply(this.random().nextInt(normal.size()))) : (IMutation)secret.apply(this.random().nextInt(secret.size()))) : (IMutation)normal.apply(this.random().nextInt(normal.size()));
        } else {
            iMutation = (IMutation)valid.head();
        }
        IMutation selected = iMutation;
        return this.getFinalMutationResult(selected, fromStack, true);
    }

    public ItemStack getFinalMutationResult(IMutation selected, ItemStack fromStack, boolean applyDecay) {
        ItemStack itemStack;
        ISpeciesRoot root = selected.getRoot();
        IIndividual individual = root.templateAsIndividual(selected.getTemplate());
        IIndividual iIndividual = individual;
        if (iIndividual instanceof IBee) {
            IBee iBee = (IBee)iIndividual;
            IBee orig = (IBee)root.getMember(fromStack);
            iBee.mate((IIndividual)iBee);
            iBee.setIsNatural(orig.isNatural());
            itemStack = root.getMemberStack((IIndividual)iBee, (ISpeciesType)EnumBeeType.QUEEN);
        } else if (iIndividual instanceof ITree) {
            ITree iTree = (ITree)iIndividual;
            itemStack = root.getMemberStack((IIndividual)iTree, (ISpeciesType)EnumGermlingType.SAPLING);
        } else {
            Gendustry$.MODULE$.logWarn(new StringBuilder().append((Object)"Don't know how to create mutation result for ").append((Object)individual.getClass().getName()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            itemStack = new ItemStack((Item)Items$.MODULE$.waste());
        }
        ItemStack res = itemStack;
        if (applyDecay) {
            return this.applyMutationDecayChance(res, fromStack);
        }
        return res;
    }

    public ItemStack applyMutationDecayChance(ItemStack result, ItemStack original) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(result);
        ISpeciesRoot iSpeciesRoot = root;
        if (iSpeciesRoot instanceof IBeeRoot) {
            IBeeRoot iBeeRoot = (IBeeRoot)iSpeciesRoot;
            IBee beeResult = iBeeRoot.getMember(result);
            IBee beeOriginal = iBeeRoot.getMember(original);
            if (beeOriginal.isNatural()) {
                if ((float)this.random().nextInt(100) < MachineMutatron$.MODULE$.degradeChanceNatural()) {
                    beeResult.setIsNatural(false);
                }
            } else if ((float)this.random().nextInt(100) < MachineMutatron$.MODULE$.deathChanceArtificial()) {
                return new ItemStack((Item)Items$.MODULE$.waste());
            }
            beeResult.writeToNBT(result.func_77978_p());
            return result;
        }
        return result;
    }

    public void addMutationToTracker(ItemStack in1, ItemStack in2, ItemStack out, GameProfile player, World world) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(in1);
        if (root != null && root.isMember(in1) && root.isMember(in2) && root.isMember(out)) {
            IAlleleSpecies sp1 = root.getMember(in1).getGenome().getPrimary();
            IAlleleSpecies sp2 = root.getMember(in2).getGenome().getPrimary();
            IAlleleSpecies spR = root.getMember(out).getGenome().getPrimary();
            IBreedingTracker tracker = root.getBreedingTracker(world, player);
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(root.getCombinations((IAllele)sp1)).asScala()).filter((Function1)new Serializable(sp1, sp2, spR){
                private final IAlleleSpecies sp1$1;
                private final IAlleleSpecies sp2$1;
                private final IAlleleSpecies spR$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(IMutation x) {
                    if (!GeneticsHelper$.MODULE$.checkMutation(x, this.sp1$1, this.sp2$1)) return false;
                    IAlleleSpecies iAlleleSpecies = GeneticsHelper$.MODULE$.getMutationSpecies(x);
                    IAlleleSpecies iAlleleSpecies2 = this.spR$1;
                    if (iAlleleSpecies != null) {
                        if (!iAlleleSpecies.equals(iAlleleSpecies2)) return false;
                        return true;
                    }
                    if (iAlleleSpecies2 == null) return true;
                    return false;
                }
                {
                    this.sp1$1 = sp1$1;
                    this.sp2$1 = sp2$1;
                    this.spR$1 = spR$1;
                }
            })).foreach((Function1)new Serializable(tracker){
                private final IBreedingTracker tracker$1;

                public final void apply(IMutation x$1) {
                    this.tracker$1.registerMutation(x$1);
                }
                {
                    this.tracker$1 = tracker$1;
                }
            });
            return;
        }
    }

    public ItemStack individualFromTemplate(ItemStack tpl, boolean pristine) {
        ISpeciesRoot iSpeciesRoot;
        block6: {
            ItemStack itemStack;
            block3: {
                IIndividual individual;
                block5: {
                    block4: {
                        block2: {
                            ISpeciesRoot root = GeneTemplate$.MODULE$.getSpecies(tpl);
                            Iterable<GeneSampleInfo> samples = GeneTemplate$.MODULE$.getSamples(tpl);
                            IAllele[] template = root.getDefaultTemplate();
                            samples.foreach((Function1)new Serializable(template){
                                private final IAllele[] template$1;

                                public final void apply(GeneSampleInfo x) {
                                    this.template$1[x.chromosome()] = x.allele();
                                }
                                {
                                    this.template$1 = template$1;
                                }
                            });
                            individual = root.templateAsIndividual(template);
                            individual.analyze();
                            iSpeciesRoot = root;
                            if (!(iSpeciesRoot instanceof IBeeRoot)) break block2;
                            IBeeRoot iBeeRoot = (IBeeRoot)iSpeciesRoot;
                            IBee bee = (IBee)individual;
                            bee.setIsNatural(pristine);
                            bee.mate((IIndividual)bee);
                            itemStack = iBeeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.QUEEN);
                            break block3;
                        }
                        if (!(iSpeciesRoot instanceof ITreeRoot)) break block4;
                        ITreeRoot iTreeRoot = (ITreeRoot)iSpeciesRoot;
                        itemStack = iTreeRoot.getMemberStack(individual, (ISpeciesType)EnumGermlingType.SAPLING);
                        break block3;
                    }
                    if (!(iSpeciesRoot instanceof IButterflyRoot)) break block5;
                    IButterflyRoot iButterflyRoot = (IButterflyRoot)iSpeciesRoot;
                    itemStack = iButterflyRoot.getMemberStack(individual, (ISpeciesType)EnumFlutterType.BUTTERFLY);
                    break block3;
                }
                if (iSpeciesRoot == null) break block6;
                Gendustry$.MODULE$.logWarn(new StringBuilder().append((Object)"Don't know how to create item from template ").append((Object)individual.getClass().getName()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                itemStack = new ItemStack((Item)Items$.MODULE$.waste());
            }
            return itemStack;
        }
        throw new MatchError((Object)iSpeciesRoot);
    }

    public boolean individualFromTemplate$default$2() {
        return false;
    }

    public ItemStack templateFromSpeciesUID(String uid) {
        ISpeciesRoot root = ((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(uid)).getRoot();
        IAllele[] template = root.getTemplate(uid);
        ItemStack item = new ItemStack((Item)GeneTemplate$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])template).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<IAllele, Object> check$ifrefutable$1) {
                Tuple2<IAllele, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<IAllele, Object> x$4) {
                Tuple2<IAllele, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    IAllele allele = (IAllele)tuple2._1();
                    boolean bl = allele != null;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).foreach((Function1)new Serializable(root, item){
            private final ISpeciesRoot root$2;
            private final ItemStack item$1;

            public final boolean apply(Tuple2<IAllele, Object> x$5) {
                Tuple2<IAllele, Object> tuple2 = x$5;
                if (tuple2 != null) {
                    IAllele allele = (IAllele)tuple2._1();
                    int chromosome = tuple2._2$mcI$sp();
                    boolean bl = GeneTemplate$.MODULE$.addSample(this.item$1, new GeneSampleInfo(this.root$2, chromosome, allele));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.root$2 = root$2;
                this.item$1 = item$1;
            }
        });
        return item;
    }

    public Map<Object, IChromosomeType> getCleanKaryotype(ISpeciesRoot root) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])root.getKaryotype()).filter((Function1)new Serializable(root){
            private final ISpeciesRoot root$1;

            public final boolean apply(IChromosomeType x) {
                return this.root$1.getDefaultTemplate()[x.ordinal()] != null;
            }
            {
                this.root$1 = root$1;
            }
        })).map((Function1)new Serializable(){

            public final Tuple2<Object, IChromosomeType> apply(IChromosomeType x) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x.ordinal())), (Object)x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
    }

    public IAlleleSpecies getMutationSpecies(IMutation m) {
        Class clazz = m.getRoot().getSpeciesChromosomeType().getAlleleClass();
        return (IAlleleSpecies)Predef$.MODULE$.refArrayOps((Object[])m.getTemplate()).find((Function1)new Serializable(clazz){
            private final Class eta$0$1$1;

            public final boolean apply(Object x$1) {
                return this.eta$0$1$1.isInstance(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }).getOrElse((Function0)new Serializable(m){
            private final IMutation m$1;

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Failed to get species from mutation %s+%s (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.m$1.getAllele0().getUID(), this.m$1.getAllele1().getUID(), this.m$1.getRoot().getUID()})));
            }
            {
                this.m$1 = m$1;
            }
        });
    }

    public Option<IIndividual> getVanillaLeafPollen(IBlockState state) {
        return Option$.MODULE$.apply(AlleleManager.leafTranslators.get(state.func_177230_c())).flatMap((Function1)new Serializable(state){
            private final IBlockState state$1;

            public final Option<ITree> apply(ILeafTranslator x) {
                return Option$.MODULE$.apply((Object)x.getTreeFromLeaf(this.state$1));
            }
            {
                this.state$1 = state$1;
            }
        });
    }

    public List<String> safeMutationConditions(IMutation m) {
        List list;
        try {
            list = (List)Option$.MODULE$.apply((Object)m.getSpecialConditions()).map((Function1)new Serializable(){

                public final List<String> apply(Collection<String> x$6) {
                    return JavaConversions$.MODULE$.collectionAsScalaIterable(x$6).toList();
                }
            }).getOrElse((Function0)new Serializable(){

                public final List<Nothing$> apply() {
                    return List$.MODULE$.empty();
                }
            });
        }
        catch (Throwable throwable) {
            Gendustry$.MODULE$.logWarnException("Error getting conditions of mutation %s + %s => %s", throwable, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m.getAllele0().getUID(), m.getAllele1().getUID(), this.getMutationSpecies(m).getUID()}));
            list = List$.MODULE$.empty();
        }
        return list;
    }

    private GeneticsHelper$() {
        MODULE$ = this;
        this.random = new Random();
    }
}

