/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock.tesr;

import mod.chiselsandbits.config.ModConfig;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.render.chiseledblock.tesr.ChisledBlockRenderChunkTESR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public abstract class GfxRenderState {
    public static int gfxRefresh = 0;

    public abstract boolean validForUse();

    public abstract boolean render();

    public abstract GfxRenderState prepare(Tessellator var1);

    public abstract void destroy();

    public boolean shouldRender() {
        return true;
    }

    public static boolean useVBO() {
        ChiselsAndBits.getConfig();
        if (ModConfig.useVBO == UseVBO.AUTOMATIC) {
            return Minecraft.func_71410_x().field_71474_y.field_178881_t;
        }
        ChiselsAndBits.getConfig();
        return ModConfig.useVBO == UseVBO.YES;
    }

    public static GfxRenderState getNewState(int vertexCount) {
        if (vertexCount == 0) {
            return new VoidRenderState();
        }
        if (GfxRenderState.useVBO()) {
            return new VBORenderState();
        }
        return new DisplayListRenderState();
    }

    public static class VBORenderState
    extends GfxRenderState {
        int refreshNum;
        VertexBuffer vertexbuffer;

        @Override
        public boolean validForUse() {
            return VBORenderState.useVBO() && this.refreshNum == gfxRefresh;
        }

        @Override
        public GfxRenderState prepare(Tessellator t) {
            if (t.func_178180_c().func_178989_h() == 0) {
                this.destroy();
                return new VoidRenderState().prepare(t);
            }
            this.destroy();
            if (this.vertexbuffer == null) {
                this.vertexbuffer = new VertexBuffer(t.func_178180_c().func_178973_g());
            }
            t.func_178180_c().func_178977_d();
            this.vertexbuffer.func_181722_a(t.func_178180_c().func_178966_f());
            this.refreshNum = gfxRefresh;
            return this;
        }

        @Override
        public boolean render() {
            if (this.vertexbuffer != null) {
                GlStateManager.func_187410_q((int)32884);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                GlStateManager.func_187410_q((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                GlStateManager.func_187410_q((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                GlStateManager.func_187410_q((int)32886);
                this.vertexbuffer.func_177359_a();
                this.setupArrayPointers();
                this.vertexbuffer.func_177358_a(7);
                OpenGlHelper.func_176072_g((int)OpenGlHelper.field_176089_P, (int)0);
                GlStateManager.func_179117_G();
                for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
                    VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
                    int i = vertexformatelement.func_177369_e();
                    switch (vertexformatelement$enumusage) {
                        case POSITION: {
                            GlStateManager.func_187429_p((int)32884);
                            break;
                        }
                        case UV: {
                            OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + i));
                            GlStateManager.func_187429_p((int)32888);
                            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                            break;
                        }
                        case COLOR: {
                            GlStateManager.func_187429_p((int)32886);
                            GlStateManager.func_179117_G();
                        }
                    }
                }
                return true;
            }
            return false;
        }

        private void setupArrayPointers() {
            GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
            GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
            GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }

        protected void finalize() throws Throwable {
            if (this.vertexbuffer != null) {
                ChisledBlockRenderChunkTESR.addNextFrameTask(new vertexBufferCleanup(this.vertexbuffer));
            }
        }

        @Override
        public void destroy() {
            if (this.vertexbuffer != null) {
                this.vertexbuffer.func_177362_c();
                this.vertexbuffer = null;
            }
        }
    }

    public static class DisplayListRenderState
    extends GfxRenderState {
        int refreshNum = 0;
        int displayList = 0;

        @Override
        public boolean validForUse() {
            return !DisplayListRenderState.useVBO() && this.refreshNum == gfxRefresh;
        }

        @Override
        public boolean render() {
            if (this.displayList != 0) {
                GlStateManager.func_179148_o((int)this.displayList);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GfxRenderState prepare(Tessellator t) {
            if (t.func_178180_c().func_178989_h() == 0) {
                this.destroy();
                return new VoidRenderState().prepare(t);
            }
            if (this.displayList == 0) {
                this.displayList = GLAllocation.func_74526_a((int)1);
            }
            try {
                GlStateManager.func_187423_f((int)this.displayList, (int)4864);
                t.func_78381_a();
                this.refreshNum = gfxRefresh;
            }
            catch (IllegalStateException e) {
                Log.logError("Erratic Tessellator Behavior", e);
                this.destroy();
                GfxRenderState gfxRenderState = null;
                return gfxRenderState;
            }
            finally {
                GlStateManager.func_187415_K();
            }
            return this;
        }

        protected void finalize() throws Throwable {
            if (this.displayList != 0) {
                ChisledBlockRenderChunkTESR.addNextFrameTask(new displayListCleanup(this.displayList));
            }
        }

        @Override
        public void destroy() {
            if (this.displayList != 0) {
                GLAllocation.func_74523_b((int)this.displayList);
                this.displayList = 0;
            }
        }
    }

    public static class VoidRenderState
    extends GfxRenderState {
        @Override
        public boolean validForUse() {
            return true;
        }

        @Override
        public boolean render() {
            return false;
        }

        @Override
        public boolean shouldRender() {
            return false;
        }

        @Override
        public GfxRenderState prepare(Tessellator t) {
            int vc = t.func_178180_c().func_178989_h();
            if (vc > 0) {
                return GfxRenderState.getNewState(vc).prepare(t);
            }
            t.func_178180_c().func_178977_d();
            return this;
        }

        @Override
        public void destroy() {
        }
    }

    private static class vertexBufferCleanup
    implements Runnable {
        final VertexBuffer vertBuffer;

        public vertexBufferCleanup(VertexBuffer buffer) {
            this.vertBuffer = buffer;
        }

        @Override
        public void run() {
            this.vertBuffer.func_177362_c();
        }
    }

    private static class displayListCleanup
    implements Runnable {
        final int dspList;

        public displayListCleanup(int x) {
            this.dspList = x;
        }

        @Override
        public void run() {
            GLAllocation.func_74523_b((int)this.dspList);
        }
    }

    public static enum UseVBO {
        AUTOMATIC,
        YES,
        NO;

    }
}

