/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters;

import com.tmtravlr.soundfilters.CommonProxy;
import com.tmtravlr.soundfilters.ModifiedLWJGLOpenALLibrary;
import com.tmtravlr.soundfilters.filters.FilterLowPass;
import com.tmtravlr.soundfilters.filters.FilterReverb;
import java.util.Comparator;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;

@Mod(modid="soundfilters", name="Sound Filters", version="0.9_for_1.9", acceptedMinecraftVersions="[1.9.4]")
public class SoundFiltersMod {
    @Mod.Instance(value="soundfilters")
    public static SoundFiltersMod soundFilters;
    @SidedProxy(clientSide="com.tmtravlr.soundfilters.ClientProxy", serverSide="com.tmtravlr.soundfilters.CommonProxy")
    public static CommonProxy proxy;
    @SideOnly(value=Side.CLIENT)
    private static Minecraft mc;
    private static Random rand;
    public static int profileSize;
    public static boolean doSkyChecks;
    public static boolean doReverb;
    public static boolean doLowPass;
    public static boolean doOcclusion;
    public static FilterLowPass lowPassFilter;
    public static FilterReverb reverbFilter;
    public static Comparator<BlockMeta> BlockComparator;
    public static TreeMap<BlockMeta, Double> customOcclusion;
    public static TreeMap<BlockMeta, Double> customReverb;
    public static boolean DEBUG;
    public static boolean SUPER_DUPER_DEBUG;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        int firstDashIndex;
        double strength;
        int meta;
        String blockName;
        Block block;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Property prop = config.get("debug", "Debug", false);
        prop.setComment("Set to true to write simple debug info to the console. [default: false]");
        DEBUG = prop.getBoolean(true);
        prop = config.get("debug", "High Output Debug", false);
        prop.setComment("You probably don't want to set this to true\nunless you actually want to debug the mod.\nIt writes quite a lot in the console. [default: false]");
        SUPER_DUPER_DEBUG = prop.getBoolean(true);
        prop = config.get("filters", "Use Reverb?", true);
        prop.setComment("Set to false to disable reverb. [default: true]");
        doReverb = prop.getBoolean(true);
        prop = config.get("filters", "Use Low Pass?", true);
        prop.setComment("Set to false to disable low pass filter in water and lava. [default: true]");
        doLowPass = prop.getBoolean(true);
        prop = config.get("filters", "Use Occluded Sounds (muting sounds behind solid walls)?", true);
        prop.setComment("Set to false to disable low pass filter for sounds behind solid walls.\nIf you are getting lag, disabling this might help. [default: true]");
        doOcclusion = prop.getBoolean(true);
        prop = config.get("reverb", "Number of blocks reverb will check through:", 1024);
        prop.setComment("If you are getting lag, set this number lower. The higher it is,\nthe more realistic the reverb will be. [range: 0 ~ 2147483647, default: 1024]");
        profileSize = prop.getInt();
        prop = config.get("reverb", "Do sky checks:", true);
        prop.setComment("If this is true, when you're in an area that can see the sky, the\nthere will be less reverb. This is for aboveground areas with\nlots of stone and such like extreme hills biomes. [default: true]");
        doSkyChecks = prop.getBoolean(true);
        String[] reverbBlocksList = new String[]{"soul_sand-16-2.0"};
        prop = config.get("reverb", "Specific block reverb:", reverbBlocksList);
        prop.setComment("Add values to this list (each on a new line) in the format \n<block id>-<metadata>-<reverb double>, to change how the block\nwith that metadata absorbs or creates reverb. If the\nmetadata is 16, that means it will apply to any metadata value.\nBy default things like wool, snow, carpets, and plants absorb reverb\n(value 0.0), things like wood and dirt are neutral (value 1.0),\nand things like stone, metal, ice, and glass create reverb (value 2.0).\nSo if, say, you wanted to add pumpkins of any metadata to the blocks\nthat create reverb, you would put pumpkin-16-2.0 on a new line. [default: [soul_sand-16-2.0]]");
        reverbBlocksList = prop.getStringList();
        String[] occlusionBlocksList = new String[]{"wool-16-2.0"};
        prop = config.get("occlusion", "Specific block occlusion:", occlusionBlocksList);
        prop.setComment("Add new entries (each on a new line) in the format\n <block id>-<metadata>-<occlusion double> to customize how much sound\nthey should absorb when they are between you and the sound source.\nFor the metadata, 16 means any metadata value. The amount is a\ndouble, with 0.0 absorbing no sound (like air), and 1.0 being the normal\namount, and 2.0 being twice the normal amount. By default,\nwool has entry wool-16-2.0 which is twice the normal sound absorbtion. [default: [wool-16-2.0]]");
        occlusionBlocksList = prop.getStringList();
        config.save();
        for (String occlusionInfo : occlusionBlocksList) {
            block = null;
            blockName = "";
            meta = -1;
            strength = -1.0;
            try {
                int lastDashIndex = occlusionInfo.lastIndexOf(45);
                firstDashIndex = occlusionInfo.substring(0, lastDashIndex).lastIndexOf(45);
                blockName = occlusionInfo.substring(0, firstDashIndex);
                meta = Integer.valueOf(occlusionInfo.substring(firstDashIndex + 1, lastDashIndex));
                strength = Double.valueOf(occlusionInfo.substring(lastDashIndex + 1));
                block = Block.func_149684_b((String)blockName);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("[Sound Filters] Error while loading in custom occlusion entry!" + (blockName == "" ? "" : " Block ID was " + blockName));
            }
            if (block == null || meta < 0 || !(strength >= 0.0)) continue;
            if (DEBUG) {
                System.out.println("[Sound Filters] Loaded custom occlusion: block " + blockName + ", with " + (meta == 16 ? "any meta" : "meta " + meta) + ", and amount " + strength);
            }
            customOcclusion.put(new BlockMeta(block, meta), strength);
        }
        for (String reverbInfo : reverbBlocksList) {
            block = null;
            blockName = "";
            meta = -1;
            strength = -1.0;
            try {
                int lastDashIndex = reverbInfo.lastIndexOf(45);
                firstDashIndex = reverbInfo.substring(0, lastDashIndex).lastIndexOf(45);
                blockName = reverbInfo.substring(0, firstDashIndex);
                meta = Integer.valueOf(reverbInfo.substring(firstDashIndex + 1, lastDashIndex));
                strength = Double.valueOf(reverbInfo.substring(lastDashIndex + 1));
                block = Block.func_149684_b((String)blockName);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("[Sound Filters] Error while loading in custom reverb entry!" + (blockName == "" ? "" : " Block ID was " + blockName));
            }
            if (block == null || meta < 0 || !(strength >= 0.0)) continue;
            if (DEBUG) {
                System.out.println("[Sound Filters] Loaded custom reverb: block " + blockName + ", with " + (meta == 16 ? "any meta" : "meta " + meta) + ", and amount " + strength);
            }
            customReverb.put(new BlockMeta(block, meta), strength);
        }
        proxy.registerTickHandlers();
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        SoundFiltersMod.reverbFilter.density = 0.0f;
        SoundFiltersMod.reverbFilter.diffusion = 0.6f;
        SoundFiltersMod.reverbFilter.gain = 0.15f;
        SoundFiltersMod.reverbFilter.gainHF = 0.8f;
        SoundFiltersMod.reverbFilter.decayTime = 0.1f;
        SoundFiltersMod.reverbFilter.decayHFRatio = 0.7f;
        SoundFiltersMod.reverbFilter.reflectionsGain = 0.6f;
        SoundFiltersMod.reverbFilter.reflectionsDelay = 0.0f;
        SoundFiltersMod.reverbFilter.lateReverbGain = 0.9f;
        SoundFiltersMod.reverbFilter.lateReverbDelay = 0.0f;
        SoundFiltersMod.reverbFilter.airAbsorptionGainHF = 0.99f;
        SoundFiltersMod.reverbFilter.roomRolloffFactor = 0.0f;
    }

    public static boolean isGamePaused() {
        return mc.func_71356_B() && SoundFiltersMod.mc.field_71462_r != null && SoundFiltersMod.mc.field_71462_r.func_73868_f() && !mc.func_71401_C().func_71344_c();
    }

    static {
        mc = Minecraft.func_71410_x();
        rand = new Random();
        profileSize = 1024;
        doSkyChecks = true;
        doReverb = true;
        doLowPass = true;
        doOcclusion = true;
        lowPassFilter = new FilterLowPass();
        reverbFilter = new FilterReverb();
        BlockComparator = new Comparator<BlockMeta>(){

            @Override
            public int compare(BlockMeta first, BlockMeta second) {
                if (Block.func_149682_b((Block)second.block) - Block.func_149682_b((Block)first.block) != 0) {
                    return Block.func_149682_b((Block)second.block) - Block.func_149682_b((Block)first.block);
                }
                if (second.meta - first.meta != 0) {
                    return second.meta - first.meta;
                }
                return 0;
            }
        };
        customOcclusion = new TreeMap(BlockComparator);
        customReverb = new TreeMap(BlockComparator);
        DEBUG = false;
        SUPER_DUPER_DEBUG = false;
        if (SoundSystemConfig.getLibraries() != null) {
            SoundSystemConfig.getLibraries().clear();
        }
        try {
            SoundSystemConfig.addLibrary(ModifiedLWJGLOpenALLibrary.class);
        }
        catch (SoundSystemException e) {
            e.printStackTrace();
            System.out.println("[Sound Filters] Problem while loading modified library!");
        }
        System.out.println("[Sound Filters] Loaded modified library.");
    }

    public static class BlockMeta {
        public Block block;
        public int meta;

        public BlockMeta(Block b, int m) {
            this.block = b;
            this.meta = m;
        }
    }
}

