/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.multistorage.common.inventory.SlotHideable;
import shetiphian.multistorage.common.tileentity.TileEntityJunkbox;

public class ContainerJunkbox
extends Container {
    private InventoryCrafting returnSlot = new InventoryCrafting((Container)this, 1, 1);
    private TileEntityJunkbox chestTile;
    private IInventory chest;
    private EntityPlayer player;
    public int usedSlots;
    public int[] usedSpace = new int[2];

    public ContainerJunkbox(EntityPlayer player, TileEntityJunkbox tile) {
        this.chestTile = tile;
        this.chest = tile.getChest();
        this.player = player;
        this.chest.func_174889_b(player);
        for (int slotId = 0; slotId < this.chest.func_70302_i_(); ++slotId) {
            this.func_75146_a(new SlotHideable(player.field_70170_p, this.chest, slotId, 0, 0));
        }
        this.func_75146_a(new Slot((IInventory)this.returnSlot, 0, 137, 11));
        int pX = 11;
        int pY = 105;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, col + row * 9 + 9, pX + col * 18, pY));
            }
            pY += 18;
        }
        pY += 4;
        for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, col, pX + col * 18, pY));
        }
        this.usedSpace[1] = this.chest.func_70302_i_() * 64;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.chest != null && this.chest.func_70300_a(player);
    }

    public void func_75134_a(EntityPlayer player) {
        ItemStack stack;
        super.func_75134_a(player);
        if (this.chest != null) {
            this.chest.func_174886_c(player);
        }
        if (!this.player.field_70170_p.field_72995_K && (stack = this.returnSlot.func_70304_b(0)) != null) {
            player.func_71019_a(stack, false);
        }
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        ItemStack stack = this.returnSlot.func_70301_a(0);
        if (stack != null && !this.chestTile.func_145831_w().field_72995_K) {
            this.func_82846_b(this.player, this.chestTile.getChestSize());
            this.func_75142_b();
        }
    }

    public void func_75142_b() {
        boolean sendBars = false;
        for (int index = 0; index < this.field_75151_b.size(); ++index) {
            Slot slot = this.func_75139_a(index);
            ItemStack curStack = slot.func_75211_c();
            ItemStack oldStack = (ItemStack)this.field_75153_a.get(index);
            if (ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)curStack)) continue;
            ItemStack setStack = curStack == null ? null : curStack.func_77946_l();
            this.field_75153_a.set(index, setStack);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((Container)this, index, setStack);
            }
            if (!(slot instanceof SlotHideable)) continue;
            this.updateGages(curStack, oldStack);
            sendBars = true;
        }
        if (sendBars) {
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71112_a((Container)this, 0, this.usedSlots);
                listener.func_71112_a((Container)this, 1, this.usedSpace[0]);
                listener.func_71112_a((Container)this, 2, this.usedSpace[1]);
            }
        }
    }

    private void updateGages(ItemStack curStack, ItemStack oldStack) {
        if (curStack == null && oldStack != null) {
            this.usedSlots = Math.max(0, this.usedSlots - 1);
            this.usedSpace[0] = Math.max(0, this.usedSpace[0] - oldStack.field_77994_a);
            this.usedSpace[1] = Math.max(0, this.usedSpace[1] - oldStack.func_77976_d());
            this.usedSpace[1] = this.usedSpace[1] + 64;
        } else if (curStack != null) {
            if (oldStack == null) {
                ++this.usedSlots;
                this.usedSpace[0] = this.usedSpace[0] + curStack.field_77994_a;
                this.usedSpace[1] = Math.max(0, this.usedSpace[1] - 64);
                this.usedSpace[1] = this.usedSpace[1] + curStack.func_77976_d();
            } else {
                this.usedSpace[0] = Math.max(0, this.usedSpace[0] - oldStack.field_77994_a);
                this.usedSpace[0] = this.usedSpace[0] + curStack.field_77994_a;
                this.usedSpace[1] = Math.max(0, this.usedSpace[1] - oldStack.func_77976_d());
                this.usedSpace[1] = this.usedSpace[1] + curStack.func_77976_d();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 0: {
                this.usedSlots = data;
                break;
            }
            case 1: {
                this.usedSpace[0] = data;
                break;
            }
            case 2: {
                this.usedSpace[1] = data;
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot clickedSlot = (Slot)this.field_75151_b.get(slotNumber);
        if (clickedSlot == null || !clickedSlot.func_75216_d()) {
            return null;
        }
        ItemStack itemInSlot = clickedSlot.func_75211_c();
        if (itemInSlot == null) {
            return null;
        }
        ItemStack returnStack = itemInSlot.func_77946_l();
        int lastStorageSlot = this.chest.func_70302_i_();
        if (slotNumber < lastStorageSlot ? !this.func_75135_a(itemInSlot, lastStorageSlot + 1, this.field_75151_b.size(), true) : !this.func_75135_a(itemInSlot, 0, lastStorageSlot, false)) {
            return null;
        }
        if (itemInSlot.field_77994_a == 0) {
            clickedSlot.func_75215_d(null);
        } else {
            clickedSlot.func_75218_e();
        }
        if (itemInSlot.field_77994_a == returnStack.field_77994_a) {
            return null;
        }
        return returnStack;
    }
}

