/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.block.IStorageType;
import shetiphian.multistorage.common.tileentity.TileEntityChameleon;

class TypeChameleon
implements IStorageType {
    private Table<BlockPos, EnumAction, Boolean> antirecursion = HashBasedTable.create();

    TypeChameleon() {
    }

    private TileEntityChameleon getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityChameleon ? (TileEntityChameleon)tile : null;
    }

    @Override
    public AxisAlignedBB getBoxBounds(BlockStorageType block, IBlockState state, IBlockAccess world, BlockPos pos) {
        Block oBlock;
        TileEntityChameleon tile = this.getTile(world, pos);
        if (tile != null && (oBlock = tile.getClonedBlock()) != null && oBlock != block) {
            return oBlock.func_185496_a(tile.getClonedState(), world, tile.getClonedPos());
        }
        return Block.field_185505_j;
    }

    @Override
    public boolean addCollisionBoxesToList(World world, BlockPos pos, IBlockState state, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity) {
        Block block;
        TileEntityChameleon tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && (block = tile.getClonedBlock()) != null && block != tile.func_145838_q()) {
            if (!this.antirecursion.contains((Object)pos, (Object)EnumAction.COLLISION)) {
                this.antirecursion.put((Object)pos, (Object)EnumAction.COLLISION, (Object)true);
                try {
                    ArrayList oList = new ArrayList();
                    block.func_185477_a(tile.getClonedState(), world, tile.getClonedPos(), Block.field_185505_j.func_186670_a(tile.getClonedPos()), oList, entity);
                    BlockPos oPos = new BlockPos(pos.func_177958_n() - tile.getClonedPos().func_177958_n(), pos.func_177956_o() - tile.getClonedPos().func_177956_o(), pos.func_177952_p() - tile.getClonedPos().func_177952_p());
                    for (AxisAlignedBB box : oList) {
                        if ((box = box.func_186670_a(oPos)) == Block.field_185506_k || !box.func_72326_a(aabb)) continue;
                        list.add(box);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.antirecursion.remove((Object)pos, (Object)EnumAction.COLLISION);
            return true;
        }
        return false;
    }

    @Override
    public void onBlockPlaced(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public void onBlockRemoved(World world, BlockPos pos, EntityPlayer player) {
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block block;
        boolean result = true;
        TileEntityChameleon tile = this.getTile(world, pos);
        if (tile != null && (block = tile.getClonedBlock()) != null && block != tile.func_145838_q() && !this.antirecursion.contains((Object)pos, (Object)EnumAction.SOLID)) {
            this.antirecursion.put((Object)pos, (Object)EnumAction.SOLID, (Object)true);
            try {
                result = block.isSideSolid(tile.getClonedState(), world, pos, side);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.antirecursion.remove((Object)pos, (Object)EnumAction.SOLID);
        return result;
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block;
        TileEntityChameleon tile;
        if (!player.func_70093_af() && (tile = this.getTile((IBlockAccess)world, pos)) != null && (block = tile.getClonedBlock()) != null && block != tile.func_145838_q()) {
            boolean result = true;
            if (!this.antirecursion.contains((Object)pos, (Object)EnumAction.ACTIVATE)) {
                this.antirecursion.put((Object)pos, (Object)EnumAction.ACTIVATE, (Object)true);
                try {
                    result = block.func_180639_a(world, tile.getClonedPos(), tile.getClonedState(), player, hand, heldItem, facing, hitX, hitY, hitZ);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.antirecursion.remove((Object)pos, (Object)EnumAction.ACTIVATE);
            return result;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)MultiStorage.INSTANCE, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        this.antirecursion.remove((Object)pos, (Object)EnumAction.ACTIVATE);
        return true;
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        Block block;
        boolean result = true;
        TileEntityChameleon tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && (block = tile.getClonedBlock()) != null && block != tile.func_145838_q() && !this.antirecursion.contains((Object)pos, (Object)EnumAction.ROTATE)) {
            this.antirecursion.put((Object)pos, (Object)EnumAction.ROTATE, (Object)true);
            try {
                result = block.rotateBlock(world, tile.getClonedPos(), axis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.antirecursion.remove((Object)pos, (Object)EnumAction.ROTATE);
        return result;
    }

    @Override
    public float getEnchantPowerBonus(World world, BlockPos pos) {
        Block block;
        float result = 0.0f;
        TileEntityChameleon tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && (block = tile.getClonedBlock()) != null && block != tile.func_145838_q() && !this.antirecursion.contains((Object)pos, (Object)EnumAction.ENCHANT)) {
            this.antirecursion.put((Object)pos, (Object)EnumAction.ENCHANT, (Object)true);
            try {
                result = block.getEnchantPowerBonus(world, tile.getClonedPos());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.antirecursion.remove((Object)pos, (Object)EnumAction.ENCHANT);
        return result;
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        Block block;
        int result = 0;
        TileEntityChameleon tile = this.getTile(world, pos);
        if (tile != null && (block = tile.getClonedBlock()) != null && block != tile.func_145838_q() && !this.antirecursion.contains((Object)pos, (Object)EnumAction.LIGHT)) {
            this.antirecursion.put((Object)pos, (Object)EnumAction.LIGHT, (Object)true);
            try {
                result = block.func_149750_m(tile.getClonedState());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.antirecursion.remove((Object)pos, (Object)EnumAction.LIGHT);
        return result;
    }

    @Override
    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        Block block;
        int result = 0;
        TileEntityChameleon tile = this.getTile(world, pos);
        if (tile != null && (block = tile.getClonedBlock()) != null && block != tile.func_145838_q() && !this.antirecursion.contains((Object)pos, (Object)EnumAction.OPACITY)) {
            this.antirecursion.put((Object)pos, (Object)EnumAction.OPACITY, (Object)true);
            try {
                result = block.func_149717_k(tile.getClonedState());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.antirecursion.remove((Object)pos, (Object)EnumAction.OPACITY);
        return result;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, BlockPos pos, int renderPass) {
        Block block;
        int result = 0xFFFFFF;
        TileEntityChameleon tile = this.getTile(world, pos);
        if (tile != null && (block = tile.getClonedBlock()) != null && block != tile.func_145838_q() && !this.antirecursion.contains((Object)pos, (Object)EnumAction.COLOR)) {
            this.antirecursion.put((Object)pos, (Object)EnumAction.COLOR, (Object)true);
            try {
                int value = Minecraft.func_71410_x().func_184125_al().func_186724_a(tile.getClonedState(), world, tile.getClonedPos(), renderPass);
                result = value < 0 ? 0xFFFFFF : value;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.antirecursion.remove((Object)pos, (Object)EnumAction.COLOR);
        return result;
    }

    private static enum EnumAction {
        COLLISION,
        SOLID,
        ACTIVATE,
        ROTATE,
        ENCHANT,
        LIGHT,
        OPACITY,
        COLOR;

    }
}

