/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.client.multipart;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mcmultipart.block.BlockCoverable;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.client.multipart.MultipartStateMapper;
import mcmultipart.multipart.PartState;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ModelMultipartContainer
implements IBakedModel {
    final IBakedModel model;
    private final Predicate<BlockRenderLayer> layerFilter;

    public ModelMultipartContainer(IBakedModel model, Predicate<BlockRenderLayer> layerFilter) {
        this.model = model;
        this.layerFilter = layerFilter;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state == null) {
            if (this.model != null) {
                return this.model.func_188616_a(state, side, rand);
            }
            return Collections.emptyList();
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (!(state instanceof IExtendedBlockState) || !((IExtendedBlockState)state).getUnlistedProperties().containsKey(BlockMultipartContainer.PROPERTY_MULTIPART_CONTAINER)) {
            if (this.model != null && this.layerFilter.apply((Object)layer)) {
                return this.model.func_188616_a(state, side, rand);
            }
            return Collections.emptyList();
        }
        List partStates = (List)((IExtendedBlockState)state).getValue(BlockMultipartContainer.PROPERTY_MULTIPART_CONTAINER);
        if (partStates == null) {
            if (this.model != null) {
                this.model.func_188616_a(state, side, rand);
            }
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (this.model != null && this.layerFilter.apply((Object)layer)) {
            quads.addAll(this.model.func_188616_a(state, side, rand));
        }
        for (PartState partState : partStates) {
            if (!partState.renderLayers.contains(MinecraftForgeClient.getRenderLayer())) continue;
            ModelResourceLocation modelLocation = new ModelResourceLocation(partState.modelPath, MultipartStateMapper.instance.func_178131_a((Map<IProperty<?>, Comparable<?>>)partState.state.func_177228_b()));
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(modelLocation);
            if (model == null) continue;
            if (partState.colorProvider != null) {
                for (BakedQuad quad : model.func_188616_a(partState.extendedState, side, rand)) {
                    if (quad.func_178212_b()) {
                        int tint = partState.colorProvider.colorMultiplier(partState.extendedState, quad.func_178211_c());
                        Color tintColor = new Color(tint, false);
                        int[] data = (int[])quad.func_178209_a().clone();
                        for (int i = 0; i < 4; ++i) {
                            Color color = new Color(data[i * 7 + 3]);
                            data[i * 7 + 3] = color.getAlpha() << 24 | color.getRed() * tintColor.getBlue() / 255 << 16 | color.getGreen() * tintColor.getGreen() / 255 << 8 | color.getBlue() * tintColor.getRed() / 255 << 0;
                        }
                        quads.add(new BakedQuad(data, 0, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
                        continue;
                    }
                    quads.add(quad);
                }
                continue;
            }
            quads.addAll(model.func_188616_a(partState.extendedState, side, rand));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.model != null ? this.model.func_177555_b() : true;
    }

    public boolean func_177556_c() {
        return this.model != null ? this.model.func_177556_c() : false;
    }

    public boolean func_188618_c() {
        return this.model != null ? this.model.func_188618_c() : false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.model != null ? this.model.func_177554_e() : Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/stone");
    }

    public ItemCameraTransforms func_177552_f() {
        return this.model != null ? this.model.func_177552_f() : ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public static ModelMultipartContainer fromBlock(IBakedModel model, final BlockCoverable block) {
        return new ModelMultipartContainer(model, new Predicate<BlockRenderLayer>(){

            public boolean apply(BlockRenderLayer layer) {
                return block.canRenderInLayerDefault(layer);
            }
        });
    }

    public static ModelMultipartContainer fromBlockState(IBakedModel model, final IBlockState state) {
        return new ModelMultipartContainer(model, new Predicate<BlockRenderLayer>(){

            public boolean apply(BlockRenderLayer layer) {
                return ((BlockCoverable)state.func_177230_c()).canRenderInLayerDefault(state, layer);
            }
        });
    }
}

