/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.api.block.IBlockWithItem;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LMUtils {
    public static final boolean DEV_ENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final Logger DEV_LOGGER = LogManager.getLogger((String)"FTBLibDev");
    public static boolean userIsLatvianModder = false;
    public static boolean isNEILoaded = false;
    public static File folderConfig;
    public static File folderMinecraft;
    public static File folderModpack;
    public static File folderLocal;
    public static File folderWorld;
    public static final Comparator<Package> PACKAGE_COMPARATOR;

    public static <T> T cast(Object o) {
        return (T)o;
    }

    public static void init(File configFolder) {
        folderConfig = configFolder;
        folderMinecraft = folderConfig.getParentFile();
        folderModpack = new File(folderMinecraft, "modpack/");
        folderLocal = new File(folderMinecraft, "local/");
        if (!folderModpack.exists()) {
            folderModpack.mkdirs();
        }
        if (!folderLocal.exists()) {
            folderLocal.mkdirs();
        }
        isNEILoaded = Loader.isModLoaded((String)"NotEnoughItems") || Loader.isModLoaded((String)"nei") || Loader.isModLoaded((String)"notenoughitems");
    }

    public static <K extends IForgeRegistryEntry<?>> void register(K object) {
        GameRegistry.register(object);
        if (object instanceof IBlockWithItem) {
            ItemBlock ib = ((IBlockWithItem)object).createItemBlock();
            ib.setRegistryName(object.getRegistryName());
            GameRegistry.register((IForgeRegistryEntry)ib);
        }
    }

    public static <E> Map<String, E> getObjects(@Nullable Class<E> type, Class<?> fields, @Nullable Object obj, boolean immutable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field f : fields.getDeclaredFields()) {
            f.setAccessible(true);
            if (type != null && !type.isAssignableFrom(f.getType())) continue;
            try {
                map.put(f.getName(), f.get(obj));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return immutable ? Collections.unmodifiableMap(map) : map;
    }

    public static <E extends IForgeRegistryEntry<E>> Map<String, E> findAndRegister(Class<E> type, String modID, Class<?> fields, @Nullable Object obj) {
        HashMap<String, IForgeRegistryEntry> map = new HashMap<String, IForgeRegistryEntry>();
        for (Field f : fields.getDeclaredFields()) {
            f.setAccessible(true);
            if (!type.isAssignableFrom(f.getType())) continue;
            try {
                IForgeRegistryEntry o = (IForgeRegistryEntry)f.get(obj);
                o.setRegistryName(new ResourceLocation(modID, f.getName().toLowerCase()));
                GameRegistry.register((IForgeRegistryEntry)o);
                map.put(f.getName().toLowerCase(), o);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return Collections.unmodifiableMap(map);
    }

    @Nullable
    public static URL get(String url) {
        try {
            return new URL(url);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getName(IBlockState state) {
        ResourceLocation id = state.func_177230_c().getRegistryName();
        return id.func_110624_b() + '_' + id.func_110623_a().replace('.', '_') + '_' + state.func_177230_c().func_176201_c(state);
    }

    static {
        PACKAGE_COMPARATOR = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }
}

