/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.tile;

import com.feed_the_beast.ftbl.lib.tile.TileLM;
import com.feed_the_beast.ftbl.lib.util.LMInvUtils;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileInvLM
extends TileLM {
    public final ItemStackHandler itemHandler;

    public TileInvLM(int size) {
        this.itemHandler = this.createHandler(size);
    }

    protected ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileInvLM.this.func_70296_d();
            }
        };
    }

    @Override
    protected boolean updateComparator() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void writeTileData(NBTTagCompound nbt) {
        super.writeTileData(nbt);
        nbt.func_74782_a("Items", (NBTBase)this.itemHandler.serializeNBT());
    }

    @Override
    public void readTileData(NBTTagCompound nbt) {
        super.readTileData(nbt);
        this.itemHandler.deserializeNBT(nbt.func_74775_l("Items"));
    }

    @Override
    public void writeTileClientData(NBTTagCompound nbt) {
        super.writeTileClientData(nbt);
        nbt.func_74782_a("Items", (NBTBase)this.itemHandler.serializeNBT());
    }

    @Override
    public void readTileClientData(NBTTagCompound nbt) {
        super.readTileClientData(nbt);
        this.itemHandler.deserializeNBT(nbt.func_74775_l("Items"));
    }

    public void dropItems() {
        if (this.isServerSide() && this.itemHandler != null && this.itemHandler.getSlots() > 0) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack item = this.itemHandler.getStackInSlot(i);
                if (item == null || item.field_77994_a <= 0) continue;
                LMInvUtils.dropItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, item, 10);
            }
        }
    }
}

