/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.net;

import com.feed_the_beast.ftbl.lib.net.MessageLM;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleChannelHandlerWrapper;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleIndexedCodec;
import net.minecraftforge.fml.relauncher.Side;

public class LMNetworkWrapper {
    private final SimpleIndexedCodec packetCodec = new SimpleIndexedCodec();
    private final FMLEmbeddedChannel serverChannels;
    private final FMLEmbeddedChannel clientChannels;

    private LMNetworkWrapper(String s) {
        EnumMap channels = NetworkRegistry.INSTANCE.newChannel(s, new ChannelHandler[]{this.packetCodec});
        this.serverChannels = (FMLEmbeddedChannel)channels.get(Side.SERVER);
        this.clientChannels = (FMLEmbeddedChannel)channels.get(Side.CLIENT);
    }

    public static LMNetworkWrapper newWrapper(String ID) {
        return new LMNetworkWrapper(ID);
    }

    private FMLEmbeddedChannel get(Side s) {
        return s.isServer() ? this.serverChannels : this.clientChannels;
    }

    public void register(int discriminator, MessageLM<?> m) {
        try {
            this.packetCodec.addDiscriminator(discriminator, m.getClass());
            FMLEmbeddedChannel channel = this.get(m.getReceivingSide());
            String type = channel.findChannelHandlerNameForType(SimpleIndexedCodec.class);
            channel.pipeline().addAfter(type, m.getClass().getName(), (ChannelHandler)new SimpleChannelHandlerWrapper(m, m.getReceivingSide(), m.getClass()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Packet getPacketFrom(IMessage message) {
        return this.serverChannels.generatePacketFrom((Object)message);
    }

    public void sendToAll(IMessage message) {
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.serverChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.serverChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.serverChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.serverChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(IMessage message) {
        this.clientChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.clientChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }
}

