/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.io;

import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.io.ByteCompressor;
import com.feed_the_beast.ftbl.lib.io.ByteCount;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.UUID;
import javax.annotation.Nullable;

public final class ByteIOStream
implements DataInput,
DataOutput {
    protected byte[] bytes;
    protected int pos;

    public ByteIOStream(int size) {
        this.bytes = new byte[size];
    }

    public ByteIOStream() {
        this(0);
    }

    private static void throwUTFException(String s) {
        try {
            throw new UTFDataFormatException(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static int getUTFLength(String data) {
        if (data == null) {
            return -1;
        }
        if (data.isEmpty()) {
            return 0;
        }
        int len = 0;
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++len;
                continue;
            }
            if (c > '\u07ff') {
                len += 3;
                continue;
            }
            len += 2;
        }
        return len;
    }

    public int getDataPos() {
        return this.pos;
    }

    public int available() {
        return this.bytes.length - this.pos;
    }

    public byte[] toByteArray() {
        if (this.pos == this.bytes.length) {
            return this.bytes;
        }
        byte[] b = new byte[this.pos];
        System.arraycopy(this.bytes, 0, b, 0, this.pos);
        return b;
    }

    public byte[] toCompressedByteArray() {
        try {
            return ByteCompressor.compress(this.bytes, 0, this.pos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void expand(int c) {
        if (this.pos + c >= this.bytes.length) {
            byte[] b = new byte[this.bytes.length + Math.max(c, 16)];
            System.arraycopy(this.bytes, 0, b, 0, this.pos);
            this.bytes = b;
        }
    }

    public void flip() {
        this.pos = 0;
    }

    public void setData(byte[] b) {
        this.bytes = b;
        this.flip();
    }

    public void setCompressedData(byte[] b) {
        try {
            this.setData(ByteCompressor.decompress(b, 0, b.length));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setData(null);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean compressed) {
        byte[] b = compressed ? this.toCompressedByteArray() : this.toByteArray();
        return "[ (" + b.length + ") " + LMStringUtils.stripB(b) + " ]";
    }

    public OutputStream createOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                ByteIOStream.this.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ByteIOStream.this.write(b, off, len);
            }
        };
    }

    public InputStream createInputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return this.available() <= 0 ? -1 : ByteIOStream.this.readUnsignedByte();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                ByteIOStream.this.readFully(b, off, len);
                return len;
            }

            @Override
            public int available() {
                return ByteIOStream.this.available();
            }
        };
    }

    @Override
    public byte readByte() {
        byte b = this.bytes[this.pos];
        ++this.pos;
        return b;
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        System.arraycopy(this.bytes, this.pos, b, off, len);
        this.pos += len;
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public void readFully(byte[] b) {
        this.readFully(b, 0, b.length);
    }

    public byte[] readByteArray(ByteCount c) {
        int s = c.read(this);
        if (s == -1) {
            return null;
        }
        byte[] b = new byte[s];
        this.readFully(b);
        return b;
    }

    @Override
    public boolean readBoolean() {
        return this.readUnsignedByte() == 1;
    }

    @Override
    public char readChar() {
        return (char)this.readUnsignedShort();
    }

    @Override
    public String readUTF() {
        int c;
        int c1;
        int l = this.readUnsignedShort();
        if (l == 0) {
            return "";
        }
        char[] utf_chars = new char[l];
        int cac = 0;
        int pos0 = this.pos;
        this.pos += l;
        for (c1 = 0; c1 < l && (c = this.bytes[c1 + pos0] & 0xFF) <= 127; ++c1) {
            utf_chars[cac++] = (char)c;
        }
        block6: while (c1 < l) {
            c = this.bytes[c1 + pos0] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++c1;
                    utf_chars[cac++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    byte c2;
                    if ((c1 += 2) > l) {
                        ByteIOStream.throwUTFException("malformed input: partial character at end");
                    }
                    if (((c2 = this.bytes[c1 + pos0 - 1]) & 0xC0) != 128) {
                        ByteIOStream.throwUTFException("malformed input around byte " + c1);
                    }
                    utf_chars[cac++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((c1 += 3) > l) {
                        ByteIOStream.throwUTFException("malformed input: partial character at end");
                    }
                    byte c2 = this.bytes[c1 + pos0 - 2];
                    byte c3 = this.bytes[c1 + pos0 - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        ByteIOStream.throwUTFException("malformed input around byte " + (c1 - 1));
                    }
                    utf_chars[cac++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block6;
                }
            }
            ByteIOStream.throwUTFException("malformed input around byte " + c1);
        }
        return new String(utf_chars, 0, cac);
    }

    @Override
    @Deprecated
    public String readLine() {
        return null;
    }

    @Override
    public int readUnsignedShort() {
        int v = Bits.toUShort(this.bytes, this.pos);
        this.pos += 2;
        return v;
    }

    @Override
    public short readShort() {
        return (short)this.readUnsignedShort();
    }

    @Override
    public int readInt() {
        int v = Bits.toInt(this.bytes, this.pos);
        this.pos += 4;
        return v;
    }

    @Override
    public long readLong() {
        long v = Bits.toLong(this.bytes, this.pos);
        this.pos += 8;
        return v;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public UUID readUUID() {
        UUID v = Bits.toUUID(this.bytes, this.pos);
        this.pos += 16;
        return v;
    }

    public int[] readIntArray(ByteCount c) {
        int len = c.read(this);
        if (len == -1) {
            return null;
        }
        int[] ai = new int[len];
        for (int i = 0; i < len; ++i) {
            ai[i] = this.readInt();
        }
        return ai;
    }

    @Override
    public void writeByte(int i) {
        this.expand(1);
        this.bytes[this.pos] = (byte)i;
        ++this.pos;
    }

    @Override
    public void write(int b) {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        this.expand(len);
        System.arraycopy(b, off, this.bytes, this.pos, len);
        this.pos += len;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void writeByteArray(byte[] b, ByteCount c) {
        if (b == null) {
            c.write(this, -1);
            return;
        }
        c.write(this, b.length);
        this.write(b);
    }

    @Override
    public void writeBoolean(boolean b) {
        this.writeByte(b ? 1 : 0);
    }

    @Override
    public void writeChar(int c) {
        this.writeShort(c);
    }

    @Override
    public void writeUTF(String s) {
        char c;
        int i;
        int sl = s.length();
        if (sl == 0) {
            this.writeShort(0);
            return;
        }
        int l = 0;
        for (i = 0; i < sl; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++l;
                continue;
            }
            if (c > '\u07ff') {
                l += 3;
                continue;
            }
            l += 2;
        }
        if (l >= 65535) {
            ByteIOStream.throwUTFException("encoded string too long: " + l + " bytes");
        }
        this.writeShort(l);
        this.expand(l);
        for (i = 0; i < sl && (c = s.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            this.writeByte(c);
        }
        while (i < sl) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte(c);
            } else if (c > '\u07ff') {
                this.writeByte(0xE0 | c >> 12 & 0xF);
                this.writeByte(0x80 | c >> 6 & 0x3F);
                this.writeByte(0x80 | c & 0x3F);
            } else {
                this.writeByte(0xC0 | c >> 6 & 0x1F);
                this.writeByte(0x80 | c & 0x3F);
            }
            ++i;
        }
    }

    @Override
    public void writeBytes(String s) {
        if (s.isEmpty()) {
            return;
        }
        for (int i = 0; i < s.length(); ++i) {
            this.writeByte((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) {
        if (s.isEmpty()) {
            return;
        }
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeShort(int s) {
        this.expand(2);
        Bits.fromUShort(this.bytes, this.pos, s);
        this.pos += 2;
    }

    @Override
    public void writeInt(int i) {
        this.expand(4);
        Bits.fromInt(this.bytes, this.pos, i);
        this.pos += 4;
    }

    @Override
    public void writeLong(long l) {
        this.expand(8);
        Bits.fromLong(this.bytes, this.pos, l);
        this.pos += 8;
    }

    @Override
    public void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeUUID(UUID uuid) {
        this.expand(16);
        Bits.fromUUID(this.bytes, this.pos, uuid);
        this.pos += 16;
    }

    public void writeIntArray(@Nullable int[] ai, ByteCount c) {
        int asize = ai == null ? -1 : ai.length;
        c.write(this, asize);
        if (ai != null) {
            for (int i = 0; i < asize; ++i) {
                this.writeInt(ai[i]);
            }
        }
    }

    @Override
    public int skipBytes(int n) {
        return 0;
    }
}

