/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.internal;

import com.feed_the_beast.ftbl.lib.LangKey;
import com.feed_the_beast.ftbl.lib.StatsLongValue;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatBasic;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class FTBLibStats {
    public static final StatBase LAST_SEEN = new StatBasic("ftbl.stat.last_seen", (ITextComponent)new TextComponentTranslation("ftbl.stat.last_seen", new Object[0])).func_150953_b(StatsLongValue.class);
    public static final StatBase FIRST_JOINED = new StatBasic("ftbl.stat.first_joined", (ITextComponent)new TextComponentTranslation("ftbl.stat.first_joined", new Object[0])).func_150953_b(StatsLongValue.class);
    public static final LangKey TIME_PLAYED_LANG = new LangKey("ftbl.stat.time_played");

    public static void init() {
        LAST_SEEN.func_75971_g();
        FIRST_JOINED.func_75971_g();
    }

    public static double getDeathsPerHour(StatisticsManagerServer stats) {
        int deaths = stats.func_77444_a(StatList.field_188069_A);
        int timePlayed = stats.func_77444_a(StatList.field_188097_g);
        if (deaths == 0 || (long)timePlayed == 0L) {
            return 0.0;
        }
        return (double)deaths / ((double)timePlayed / 72000.0);
    }

    public static long getLastSeen(StatisticsManagerServer stats, boolean isOnline) {
        if (isOnline) {
            return System.currentTimeMillis();
        }
        StatsLongValue v = (StatsLongValue)stats.func_150870_b(LAST_SEEN);
        return v == null ? 0L : v.get();
    }

    public static Object getLastSeenTimeString(StatisticsManagerServer stats, boolean online) {
        if (online) {
            return GuiLang.LABEL_ONLINE.textComponent(new Object[0]);
        }
        return LMStringUtils.getTimeString(System.currentTimeMillis() - FTBLibStats.getLastSeen(stats, false));
    }

    public static double getLastSeenDeltaInHours(StatisticsManagerServer stats, boolean isOnline) {
        if (isOnline) {
            return 0.0;
        }
        return (double)(System.currentTimeMillis() - FTBLibStats.getLastSeen(stats, false)) / 3600000.0;
    }

    public static long getFirstJoined(StatisticsManagerServer stats) {
        StatsLongValue v = (StatsLongValue)stats.func_150870_b(FIRST_JOINED);
        return v == null ? 0L : v.get();
    }

    public static void updateLastSeen(StatisticsManagerServer stats) {
        long ms = System.currentTimeMillis();
        StatsLongValue lv = (StatsLongValue)stats.func_150870_b(LAST_SEEN);
        if (lv == null) {
            lv = (StatsLongValue)stats.func_150872_a(LAST_SEEN, (IJsonSerializable)new StatsLongValue());
        }
        lv.set(ms);
        lv = (StatsLongValue)stats.func_150870_b(FIRST_JOINED);
        if (lv == null) {
            stats.func_150872_a(FIRST_JOINED, (IJsonSerializable)new StatsLongValue().set(ms));
        }
    }
}

