/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.api.info.IPageIconRenderer;
import com.feed_the_beast.ftbl.api.info.ISpecialInfoButton;
import com.feed_the_beast.ftbl.lib.FinalIDObject;
import com.feed_the_beast.ftbl.lib.RemoveFilter;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiInfo;
import com.feed_the_beast.ftbl.lib.info.ButtonInfoPage;
import com.feed_the_beast.ftbl.lib.info.InfoExtendedTextLine;
import com.feed_the_beast.ftbl.lib.info.InfoPageHelper;
import com.feed_the_beast.ftbl.lib.info.InfoTextLineString;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMMapUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InfoPage
extends FinalIDObject {
    private static final Comparator<Map.Entry<String, InfoPage>> COMPARATOR = (o1, o2) -> ((InfoPage)o1.getValue()).getDisplayName().func_150260_c().compareToIgnoreCase(((InfoPage)o2.getValue()).getDisplayName().func_150260_c());
    private static final RemoveFilter<Map.Entry<String, InfoPage>> CLEANUP_FILTER = entry -> ((InfoPage)entry.getValue()).childPages.isEmpty() && InfoPageHelper.getUnformattedText((InfoPage)entry.getValue()).trim().isEmpty();
    private final List<IInfoTextLine> text = new ArrayList<IInfoTextLine>();
    private final LinkedHashMap<String, InfoPage> childPages = new LinkedHashMap(0);
    public InfoPage parent = null;
    private ITextComponent title;
    private IPageIconRenderer pageIcon;

    public InfoPage(String id) {
        super(id);
    }

    public InfoPage(String id, @Nullable InfoPage p, JsonElement json) {
        this(id);
        this.setParent(p);
        if (!json.isJsonObject()) {
            return;
        }
        JsonObject o = json.getAsJsonObject();
        if (o.has("N")) {
            this.setTitle(LMJsonUtils.deserializeTextComponent(o.get("N")));
        }
        if (o.has("T")) {
            JsonArray a = o.get("T").getAsJsonArray();
            for (int i = 0; i < a.size(); ++i) {
                this.text.add(InfoPageHelper.createLine(this, a.get(i)));
            }
        }
        if (o.has("S")) {
            JsonObject o1 = o.get("S").getAsJsonObject();
            for (Map.Entry entry : o1.entrySet()) {
                this.childPages.put((String)entry.getKey(), new InfoPage((String)entry.getKey(), this, (JsonElement)entry.getValue()));
            }
        }
    }

    @Nullable
    public InfoPage getParent() {
        return this.parent;
    }

    public String getFullID() {
        InfoPage parent = this.getParent();
        return parent == null ? this.func_176610_l() : parent.getFullID() + '.' + this.func_176610_l();
    }

    public ITextComponent getDisplayName() {
        return this.title == null ? new TextComponentString(this.func_176610_l()) : this.title;
    }

    public void setParent(@Nullable InfoPage c) {
        this.parent = c;
    }

    public void println(@Nullable Object o) {
        if (o == null) {
            this.text.add(null);
        } else if (o instanceof IInfoTextLine) {
            this.text.add((IInfoTextLine)o);
        } else if (o instanceof ITextComponent) {
            ITextComponent c = (ITextComponent)o;
            if (c instanceof TextComponentString && c.func_150256_b().func_150229_g() && c.func_150253_a().isEmpty()) {
                this.text.add(new InfoTextLineString(((TextComponentString)c).func_150265_g()));
            } else {
                this.text.add(new InfoExtendedTextLine(c));
            }
        } else {
            this.text.add(new InfoTextLineString(String.valueOf(o)));
        }
    }

    public void addSub(InfoPage c) {
        this.childPages.put(c.func_176610_l(), c);
        c.setParent(this);
    }

    public InfoPage getSub(String id) {
        InfoPage c = this.childPages.get(id);
        if (c == null) {
            c = new InfoPage(id);
            c.setParent(this);
            this.childPages.put(c.func_176610_l(), c);
        }
        return c;
    }

    public void clear() {
        this.setTitle(null);
        this.text.clear();
        this.childPages.clear();
    }

    public void cleanup() {
        this.childPages.values().forEach(InfoPage::cleanup);
        LMMapUtils.removeAll(this.childPages, CLEANUP_FILTER);
    }

    public void sort(boolean tree) {
        LMMapUtils.sortMap(this.childPages, COMPARATOR);
        if (tree) {
            this.childPages.values().forEach(page -> page.sort(true));
        }
    }

    public void copyFrom(InfoPage c) {
        for (IInfoTextLine l : c.text) {
            this.text.add(l == null ? null : l.copy(this));
        }
        this.childPages.forEach((key, value) -> {
            InfoPage p1 = new InfoPage((String)key);
            p1.copyFrom((InfoPage)value);
            this.addSub(p1);
        });
    }

    public JsonElement toJson() {
        JsonObject o = new JsonObject();
        if (this.title != null) {
            o.add("N", LMJsonUtils.serializeTextComponent(this.title));
        }
        if (!this.text.isEmpty()) {
            JsonArray a = new JsonArray();
            for (IInfoTextLine c : this.text) {
                a.add((JsonElement)(c == null ? JsonNull.INSTANCE : c.getJson()));
            }
            o.add("T", (JsonElement)a);
        }
        if (!this.childPages.isEmpty()) {
            JsonObject o1 = new JsonObject();
            this.childPages.forEach((key, value) -> o1.add(key, value.toJson()));
            o.add("S", (JsonElement)o1);
        }
        return o;
    }

    @Nullable
    public final ITextComponent getTitle() {
        return this.title;
    }

    public InfoPage setTitle(@Nullable ITextComponent t) {
        this.title = t;
        return this;
    }

    public final List<IInfoTextLine> getText() {
        return this.text;
    }

    public final LinkedHashMap<String, InfoPage> getPages() {
        return this.childPages;
    }

    public void refreshGui(IGui gui) {
    }

    @Nullable
    public ISpecialInfoButton createSpecialButton(IGui gui) {
        return null;
    }

    public InfoPage setIcon(IPageIconRenderer icon) {
        this.pageIcon = icon;
        return this;
    }

    public IWidget createWidget(IGui gui) {
        return new ButtonInfoPage((GuiInfo)gui, this, this.pageIcon);
    }
}

