/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.api.gui.IClientActionGui;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.api.info.ISpecialInfoButton;
import com.feed_the_beast.ftbl.lib.client.ColoredObject;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.client.TextureCoords;
import com.feed_the_beast.ftbl.lib.gui.ButtonLM;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLM;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.PanelLM;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.WidgetLM;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiConfigs;
import com.feed_the_beast.ftbl.lib.info.ButtonInfoPage;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiInfo
extends GuiLM
implements IClientActionGui {
    private static final ResourceLocation TEXTURE = FTBLibFinals.get("textures/gui/info.png");
    private static final TextureCoords TEX_SLIDER = TextureCoords.fromCoords(TEXTURE, 0, 30, 12, 18, 64, 64);
    private static final TextureCoords TEX_BACK = TextureCoords.fromCoords(TEXTURE, 13, 30, 14, 11, 64, 64);
    private static final TextureCoords TEX_CLOSE = TextureCoords.fromCoords(TEXTURE, 13, 41, 14, 11, 64, 64);
    private static final TextureCoords TEX_BULLET = TextureCoords.fromCoords(TEXTURE, 0, 49, 6, 6, 64, 64);
    private static final TextureCoords TEX_BG_MU = TextureCoords.fromCoords(TEXTURE, 14, 0, 1, 13, 64, 64);
    private static final TextureCoords TEX_BG_MD = TextureCoords.fromCoords(TEXTURE, 14, 16, 1, 13, 64, 64);
    private static final TextureCoords TEX_BG_ML = TextureCoords.fromCoords(TEXTURE, 0, 14, 13, 1, 64, 64);
    private static final TextureCoords TEX_BG_MR = TextureCoords.fromCoords(TEXTURE, 16, 14, 13, 1, 64, 64);
    private static final TextureCoords TEX_BG_NN = TextureCoords.fromCoords(TEXTURE, 0, 0, 13, 13, 64, 64);
    private static final TextureCoords TEX_BG_PN = TextureCoords.fromCoords(TEXTURE, 16, 0, 13, 13, 64, 64);
    private static final TextureCoords TEX_BG_NP = TextureCoords.fromCoords(TEXTURE, 0, 16, 13, 13, 64, 64);
    private static final TextureCoords TEX_BG_PP = TextureCoords.fromCoords(TEXTURE, 16, 16, 13, 13, 64, 64);
    public static final IDrawableObject FILLING = (x, y, w, h) -> GuiHelper.drawBlankRect(x + 4, y + 4, w - 8, h - 8);
    public static final IDrawableObject BORDERS = (x, y, w, h) -> {
        TEX_BG_MU.draw(x + 13, y, w - 24, 13);
        TEX_BG_MR.draw(x + w - 13, y + 13, 13, h - 25);
        TEX_BG_MD.draw(x + 13, y + h - 13, w - 24, 13);
        TEX_BG_ML.draw(x, y + 13, 13, h - 25);
        TEX_BG_NN.draw(x, y, 13, 13);
        TEX_BG_NP.draw(x, y + h - 13, 13, 13);
        TEX_BG_PN.draw(x + w - 13, y, 13, 13);
        TEX_BG_PP.draw(x + w - 13, y + h - 13, 13, 13);
    };
    public final InfoPage pageTree;
    public final PanelLM panelPages;
    public final PanelLM panelText;
    public final PanelScrollBar sliderPages;
    public final PanelScrollBar sliderText;
    private final ButtonLM buttonBack;
    private final ButtonSpecial buttonSpecial;
    public int panelWidth;
    private int colorText;
    private int colorBackground;
    private InfoPage selectedPage;

    public GuiInfo(InfoPage tree) {
        super(0, 0);
        this.selectedPage = this.pageTree = tree;
        this.buttonBack = new ButtonLM(0, 0, 14, 11){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiInfo.this.sliderPages.setValue(gui, 0.0);
                GuiInfo.this.sliderText.setValue(gui, 0.0);
                GuiInfo.this.setSelectedPage(GuiInfo.this.selectedPage.getParent());
            }

            @Override
            public String getTitle(IGui gui) {
                return GuiInfo.this.selectedPage.getParent() == null ? GuiLang.BUTTON_CLOSE.translate(new Object[0]) : GuiLang.BUTTON_BACK.translate(new Object[0]);
            }
        };
        this.buttonBack.setIcon(new ColoredObject((IDrawableObject)TEX_CLOSE, GuiConfigs.INFO_TEXT.getColor()));
        this.panelPages = new PanelLM(0, 0, 0, 0){

            @Override
            public void addWidgets() {
                for (InfoPage c : GuiInfo.this.selectedPage.getPages().values()) {
                    this.add(c.createWidget(GuiInfo.this));
                }
                GuiInfo.this.buttonSpecial.updateButton(GuiInfo.this);
            }

            @Override
            public void updateWidgetPositions() {
                if (!this.getWidgets().isEmpty()) {
                    GuiInfo.this.sliderPages.setElementSize(this.alignWidgetsByHeight());
                }
            }
        };
        this.panelPages.addFlags(3);
        this.panelText = new PanelLM(0, 0, 0, 0){

            @Override
            public void addWidgets() {
                for (IWidget w : GuiInfo.this.panelPages.getWidgets()) {
                    if (!(w instanceof ButtonInfoPage)) continue;
                    ((ButtonInfoPage)w).updateTitle(GuiInfo.this);
                }
                boolean uni = GuiInfo.this.getFont().func_82883_a();
                GuiInfo.this.getFont().func_78264_a(true);
                for (IInfoTextLine line : GuiInfo.this.selectedPage.getText()) {
                    this.add(line == null ? new WidgetLM(0, 0, GuiInfo.this.panelText.getWidth(), GuiInfo.this.getFont().field_78288_b + 1) : line.createWidget(GuiInfo.this, GuiInfo.this.panelText));
                }
                GuiInfo.this.getFont().func_78264_a(uni);
            }

            @Override
            public void updateWidgetPositions() {
                if (!this.getWidgets().isEmpty()) {
                    int s = this.alignWidgetsByHeight(2, 0, 4);
                    GuiInfo.this.sliderText.setElementSize(s);
                    GuiInfo.this.sliderText.setSrollStepFromOneElementSize((s - 6) / this.getWidgets().size());
                }
            }
        };
        this.panelText.addFlags(7);
        this.sliderPages = new PanelScrollBar(0, 0, 12, 0, 18, this.panelPages);
        this.sliderPages.slider = TEX_SLIDER;
        this.sliderPages.background = ImageProvider.NULL;
        this.sliderText = new PanelScrollBar(0, 0, 12, 0, 18, this.panelText);
        this.sliderText.slider = TEX_SLIDER;
        this.sliderText.background = ImageProvider.NULL;
        this.buttonSpecial = new ButtonSpecial();
    }

    public InfoPage getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(@Nullable InfoPage p) {
        this.sliderText.setValue(this, 0.0);
        if (this.selectedPage != p) {
            if (p == null) {
                this.mc.field_71439_g.func_71053_j();
                return;
            }
            this.selectedPage = p;
            if (p.getPages().isEmpty()) {
                this.panelText.refreshWidgets();
            } else {
                this.refreshWidgets();
            }
        }
        this.buttonSpecial.updateButton(this);
        this.buttonBack.setIcon(new ColoredObject((IDrawableObject)(this.selectedPage.getParent() == null ? TEX_CLOSE : TEX_BACK), this.colorText));
    }

    @Override
    public void addWidgets() {
        this.selectedPage.refreshGui(this);
        this.add(this.sliderText);
        this.add(this.buttonBack);
        this.add(this.panelPages);
        this.add(this.panelText);
        this.add(this.buttonSpecial);
        this.add(this.sliderPages);
    }

    @Override
    public void onInit() {
        this.posX = GuiConfigs.INFO_BORDER_WIDTH.getInt();
        this.posY = GuiConfigs.INFO_BORDER_HEIGHT.getInt();
        int width = this.getScreen().func_78326_a() - this.posX * 2;
        int height = this.getScreen().func_78328_b() - this.posY * 2;
        this.setWidth(width);
        this.setHeight(height);
        this.panelWidth = (int)((double)width * 0.3);
        this.panelPages.posX = 10;
        this.panelPages.posY = 43;
        this.panelPages.setWidth(this.panelWidth - 17);
        this.panelPages.setHeight(height - 49);
        this.panelText.posX = this.panelWidth + 10;
        this.panelText.posY = 6;
        this.panelText.setWidth(width - this.panelWidth - 23 - this.sliderText.getWidth());
        this.panelText.setHeight(height - 12);
        this.sliderPages.posX = this.panelWidth - this.sliderPages.getWidth() - 10;
        this.sliderPages.posY = 46;
        this.sliderPages.setHeight(height - 56);
        this.sliderText.posY = 10;
        this.sliderText.setHeight(height - 20);
        this.sliderText.posX = width - 10 - this.sliderText.getWidth();
        this.buttonBack.posX = 12;
        this.buttonBack.posY = 12;
        this.colorText = GuiConfigs.INFO_TEXT.getColor();
        this.colorBackground = GuiConfigs.INFO_BACKGROUND.getColor();
        this.buttonSpecial.posX = this.panelWidth - 24;
        this.buttonSpecial.posY = 10;
    }

    @Override
    public void drawBackground() {
        int width = this.getWidth();
        int height = this.getHeight();
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        LMColorUtils.GL_COLOR.set(this.colorBackground, 255);
        FILLING.draw(this.posX + this.panelWidth, this.posY, width - this.panelWidth, height);
        FILLING.draw(this.posX, this.posY + 36, this.panelWidth, height - 36);
        FILLING.draw(this.posX, this.posY, this.panelWidth, 36);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.pushScissor(this.getScreen(), this.posX, this.posY, this.panelWidth, 36);
        this.getFont().func_78276_b(this.selectedPage.getDisplayName().func_150254_d(), this.buttonBack.getAX() + this.buttonBack.getWidth() + 5, this.posY + 14, this.colorText);
        GuiHelper.popScissor();
    }

    @Override
    public void drawForeground() {
        int width = this.getWidth();
        int height = this.getHeight();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BORDERS.draw(this.posX + this.panelWidth, this.posY, width - this.panelWidth, height);
        BORDERS.draw(this.posX, this.posY + 36, this.panelWidth, height - 36);
        BORDERS.draw(this.posX, this.posY, this.panelWidth, 36);
        super.drawForeground();
    }

    @Override
    public int getTextColor() {
        return this.colorText;
    }

    @Override
    public boolean drawDefaultBackground() {
        return false;
    }

    @Override
    public void onClientDataChanged() {
        this.refreshWidgets();
    }

    private static class ButtonSpecial
    extends ButtonLM {
        private ISpecialInfoButton specialInfoButton;

        public ButtonSpecial() {
            super(0, 0, 16, 16);
        }

        @Override
        public boolean isEnabled(IGui gui) {
            return this.specialInfoButton != null;
        }

        private void updateButton(GuiInfo gui) {
            this.specialInfoButton = gui.selectedPage.createSpecialButton(gui);
            this.setTitle(this.isEnabled(gui) ? this.specialInfoButton.getTitle() : "");
        }

        @Override
        public void onClicked(IGui gui, IMouseButton button) {
            if (this.isEnabled(gui)) {
                this.specialInfoButton.onClicked(button);
            }
        }

        @Override
        public void renderWidget(IGui gui) {
            if (this.isEnabled(gui)) {
                this.specialInfoButton.render(gui, this.getAX(), this.getAY());
            }
        }
    }
}

