/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IPanel;
import com.feed_the_beast.ftbl.lib.gui.SliderLM;

public class PanelScrollBar
extends SliderLM {
    public final IPanel panel;
    private int elementSize;
    private double scrollStep;

    public PanelScrollBar(int x, int y, int w, int h, int ss, IPanel p) {
        super(x, y, w, h, ss);
        this.panel = p;
    }

    public void setElementSize(int s) {
        this.elementSize = s;
        if (this.panel.getWidgets().isEmpty()) {
            this.setScrollStep(0.0);
        } else {
            this.setSrollStepFromOneElementSize(this.elementSize / this.panel.getWidgets().size());
        }
    }

    public void setScrollStep(double v) {
        this.scrollStep = v;
    }

    public void setSrollStepFromOneElementSize(int s) {
        this.setScrollStep((double)s / (double)(this.elementSize - this.panel.getHeight()));
    }

    @Override
    public boolean canMouseScroll(IGui gui) {
        return super.canMouseScroll(gui) || gui.isMouseOver(this.panel);
    }

    @Override
    public double getScrollStep() {
        return this.scrollStep;
    }

    @Override
    public void onMoved(IGui gui) {
        if (this.getDirection().isVertical()) {
            this.panel.setScrollY(this.getValue(gui), this.elementSize);
        } else {
            this.panel.setScrollX(this.getValue(gui), this.elementSize);
        }
    }

    @Override
    public boolean isEnabled(IGui gui) {
        return this.elementSize > (this.getDirection().isVertical() ? this.panel.getHeight() : this.panel.getHeight());
    }

    @Override
    public boolean shouldRender(IGui gui) {
        return this.isEnabled(gui);
    }
}

