/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.PropertyBase;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class PropertyDouble
extends PropertyBase {
    public static final String ID = "double";
    private double value;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;

    public PropertyDouble() {
    }

    public PropertyDouble(double v) {
        this.value = v;
    }

    public PropertyDouble(double v, double mn, double mx) {
        this.value = v;
        this.min = mn;
        this.max = mx;
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    public void setDouble(double v) {
        this.value = v;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getDouble();
    }

    public PropertyDouble setMin(double v) {
        this.min = v;
        return this;
    }

    public PropertyDouble setMax(double v) {
        this.max = v;
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public String getString() {
        return Double.toString(this.getDouble());
    }

    @Override
    public boolean getBoolean() {
        return this.getDouble() != 0.0;
    }

    @Override
    public int getInt() {
        return (int)this.getDouble();
    }

    @Override
    public IConfigValue copy() {
        return new PropertyDouble(this.getDouble());
    }

    @Override
    public boolean equalsValue(IConfigValue value) {
        return this.getDouble() == value.getDouble();
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    @Override
    public void addInfo(IConfigKey key, List<String> list) {
        super.addInfo(key, list);
        double m = this.getMin();
        if (m != Double.NEGATIVE_INFINITY) {
            list.add(TextFormatting.AQUA + "Min: " + LMStringUtils.formatDouble(m));
        }
        if ((m = this.getMax()) != Double.POSITIVE_INFINITY) {
            list.add(TextFormatting.AQUA + "Max: " + LMStringUtils.formatDouble(m));
        }
    }

    @Override
    public boolean setValueFromString(String text, boolean simulate) {
        if (MathHelperLM.canParseDouble(text)) {
            if (!simulate) {
                this.setDouble(Double.parseDouble(text));
            }
            return true;
        }
        return false;
    }

    public void func_152753_a(JsonElement json) {
        this.setDouble(json.getAsDouble());
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.getDouble());
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeDouble(this.getDouble());
        data.writeDouble(this.getMin());
        data.writeDouble(this.getMax());
    }

    @Override
    public void readData(ByteBuf data) {
        this.setDouble(data.readDouble());
        this.setMin(data.readDouble());
        this.setMax(data.readDouble());
    }
}

